#!/bin/bash -eu
#
# Based on https://github.com/google/oss-fuzz/blob/2f05cb93cbd30755a0e7ce57d28831ce4f51ae52/projects/poppler/Dockerfile
# Copyright 2018 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
################################################################################

apt-get update && apt-get install -y wget autoconf automake libtool pkg-config gperf python
pip3 install meson ninja gyp-next packaging

git clone --depth 1 https://github.com/madler/zlib.git
git clone --depth 1 https://gitlab.freedesktop.org/freetype/freetype.git
git clone --depth 1 https://github.com/mm2/Little-CMS.git
git clone --depth 1 https://github.com/uclouvain/openjpeg
# Pin libpng to avoid a build failure:
# configure: pkgconfig directory is ${libdir}/pkgconfig
# ./configure: line 10024: syntax error near unexpected token `)'
# ./configure: line 10024: `            riscv*)'
git clone https://github.com/glennrp/libpng.git && cd libpng && git checkout b4800bae3379f1abf82359703c28e727b5df4135 && cd ..
git clone --depth 1 https://gitlab.freedesktop.org/fontconfig/fontconfig.git
git clone --depth 1 https://gitlab.freedesktop.org/cairo/cairo.git
git clone --depth 1 --branch=dev git://code.qt.io/qt/qtbase.git
# Pin libpango to avoid build failure:
# Header for g_sort_array() was not included in gen_script_for_lang.c
# https://gitlab.gnome.org/GNOME/pango/-/commits/main/tools/gen-script-for-lang.c?ref_type=heads
git clone https://gitlab.gnome.org/GNOME/pango.git && cd pango && git checkout d0cd499e17cdcfdc3f7a93d0d28a3df3c5f9b10e && cd ..
wget https://ftp.gnome.org/pub/gnome/sources/glib/2.80/glib-2.80.0.tar.xz && tar xvJf $SRC/glib-2.80.0.tar.xz && rm $SRC/glib-2.80.0.tar.xz
wget https://archives.boost.io/release/1.87.0/source/boost_1_87_0.tar.bz2 && tar xvjf $SRC/boost_1_87_0.tar.bz2 && rm $SRC/boost_1_87_0.tar.bz2
wget https://ftp.mozilla.org/pub/security/nss/releases/NSS_3_99_RTM/src/nss-3.99-with-nspr-4.35.tar.gz && tar xvzf $SRC/nss-3.99-with-nspr-4.35.tar.gz && rm $SRC/nss-3.99-with-nspr-4.35.tar.gz
git clone --depth 1 --single-branch https://gitlab.freedesktop.org/poppler/poppler-data.git
git clone --depth 1 --single-branch https://gitlab.freedesktop.org/poppler/test.git $SRC/poppler-test

git clone --depth 1 https://github.com/mozilla/pdf.js pdf.js && \
    zip -q $SRC/poppler_seed_corpus.zip pdf.js/test/pdfs/*.pdf && \
    rm -rf pdf.js
wget -O poppler.dict https://raw.githubusercontent.com/google/fuzzing/master/dictionaries/pdf.dict
