//========================================================================
//
// annot_stamp_sold.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_SOLD_H
#define ANNOT_STAMP_SOLD_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_SOLD_WIDTH = 74.508179;
static const double ANNOT_STAMP_SOLD_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_SOLD = "1 0 0 -1 0 26.484744 cm\n"
                                      "q\n"
                                      "1 1 1 rg /a0 gs\n"
                                      "3.406 2.129 m 71.117 2.129 l 71.82 2.129 72.387 2.695 72.387 3.398 c 72.387\n"
                                      " 23.09 l 72.387 23.793 71.82 24.359 71.117 24.359 c 3.406 24.355 l 2.703\n"
                                      " 24.355 2.137 23.789 2.137 23.086 c 2.137 3.395 l 2.137 2.691 2.703 2.125\n"
                                      " 3.406 2.125 c h\n"
                                      "3.406 2.129 m f\n"
                                      "0.74902 0.0117647 0.0117647 rg /a1 gs\n"
                                      "1 1 1 RG 0.531496 w\n"
                                      "0 J\n"
                                      "0 j\n"
                                      "[] 0.0 d\n"
                                      "4 M q 1 0 0 1 0 0 cm\n"
                                      "27.375 16.395 m 27.375 17.902 26.812 19.059 25.691 19.859 c 24.578 20.652\n"
                                      " 22.938 21.051 20.773 21.051 c 18.801 21.051 17.25 20.699 16.129 20 c 15.008\n"
                                      " 19.301 14.285 18.242 13.965 16.82 c 17.078 16.309 l 17.289 17.125 17.699\n"
                                      " 17.719 18.312 18.09 c 18.926 18.453 19.773 18.637 20.859 18.637 c 23.109\n"
                                      " 18.637 24.234 17.953 24.234 16.582 c 24.234 16.145 24.102 15.785 23.84 \n"
                                      "15.5 c 23.586 15.215 23.219 14.98 22.746 14.789 c 22.281 14.602 21.379 14.371\n"
                                      " 20.047 14.102 c 18.895 13.832 18.094 13.617 17.645 13.457 c 17.191 13.289\n"
                                      " 16.785 13.098 16.422 12.879 c 16.059 12.652 15.75 12.383 15.492 12.07 c\n"
                                      " 15.238 11.758 15.035 11.391 14.891 10.965 c 14.754 10.543 14.684 10.059\n"
                                      " 14.684 9.512 c 14.684 8.121 15.203 7.059 16.246 6.32 c 17.297 5.578 18.816\n"
                                      " 5.207 20.812 5.207 c 22.723 5.207 24.152 5.504 25.105 6.102 c 26.066 6.699\n"
                                      " 26.688 7.688 26.965 9.062 c 23.84 9.488 l 23.68 8.824 23.352 8.328 22.855\n"
                                      " 7.992 c 22.367 7.656 21.664 7.488 20.746 7.488 c 18.793 7.488 17.816 8.102\n"
                                      " 17.816 9.324 c 17.816 9.727 17.918 10.051 18.121 10.309 c 18.332 10.562\n"
                                      " 18.641 10.781 19.051 10.965 c 19.457 11.141 20.285 11.363 21.531 11.633\n"
                                      " c 23.012 11.945 24.066 12.238 24.699 12.508 c 25.34 12.77 25.848 13.078\n"
                                      " 26.219 13.438 c 26.59 13.789 26.875 14.211 27.07 14.703 c 27.266 15.191\n"
                                      " 27.367 15.754 27.367 16.398 c h\n"
                                      "27.375 16.395 m B Q\n"
                                      "0.74902 0.0117647 0.0117647 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                      "41.043 14.906 m 41.043 16.82 40.512 18.328 39.449 19.418 c 38.387 20.504\n"
                                      " 36.914 21.047 35.035 21.047 c 33.191 21.047 31.746 20.5 30.695 19.406 c\n"
                                      " 29.645 18.312 29.121 16.812 29.121 14.906 c 29.121 13.004 29.645 11.512\n"
                                      " 30.695 10.426 c 31.746 9.332 33.211 8.785 35.098 8.785 c 37.027 8.785 38.5\n"
                                      " 9.312 39.512 10.371 c 40.531 11.422 41.043 12.93 41.043 14.906 c h\n"
                                      "37.832 14.906 m 37.832 13.5 37.602 12.48 37.145 11.848 c 36.688 11.215 \n"
                                      "36.02 10.898 35.145 10.898 c 33.281 10.898 32.348 12.234 32.348 14.91 c \n"
                                      "32.348 16.23 32.574 17.234 33.023 17.926 c 33.48 18.609 34.141 18.953 35\n"
                                      " 18.953 c 36.887 18.953 37.828 17.605 37.828 14.91 c h\n"
                                      "37.832 14.906 m B Q\n"
                                      "0.74902 0.0117647 0.0117647 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                      "43.48 4.613 3.07 16.215 re B Q\n"
                                      "0.74902 0.0117647 0.0117647 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                      "57.359 20.828 m 57.332 20.719 57.293 20.445 57.25 20.008 c 57.215 19.562\n"
                                      " 57.195 19.195 57.195 18.902 c 57.152 18.902 l 56.488 20.332 55.23 21.043\n"
                                      " 53.371 21.043 c 51.996 21.043 50.93 20.508 50.18 19.438 c 49.43 18.359 \n"
                                      "49.055 16.855 49.055 14.926 c 49.055 12.965 49.449 11.453 50.234 10.391 \n"
                                      "c 51.027 9.32 52.148 8.785 53.602 8.785 c 54.438 8.785 55.16 8.961 55.766\n"
                                      " 9.309 c 56.379 9.66 56.848 10.18 57.176 10.871 c 57.199 10.871 l 57.176\n"
                                      " 8.926 l 57.176 4.609 l 60.246 4.609 l 60.246 18.246 l 60.246 18.973 60.273\n"
                                      " 19.836 60.332 20.824 c h\n"
                                      "57.219 14.852 m 57.219 13.578 57.004 12.598 56.574 11.914 c 56.152 11.223\n"
                                      " 55.523 10.875 54.695 10.875 c 53.871 10.875 53.262 11.211 52.859 11.879\n"
                                      " c 52.457 12.543 52.258 13.559 52.258 14.926 c 52.258 17.605 53.062 18.945\n"
                                      " 54.672 18.945 c 55.48 18.945 56.105 18.594 56.551 17.887 c 56.996 17.172\n"
                                      " 57.219 16.16 57.219 14.848 c h\n"
                                      "57.219 14.852 m B Q\n"
                                      "Q q\n"
                                      "0.74902 0.0117647 0.0117647 rg /a1 gs\n"
                                      "1 1 1 RG 0.797243 w\n"
                                      "1 J\n"
                                      "1 j\n"
                                      "[] 0.0 d\n"
                                      "4 M q 1 0 0 1 0 0 cm\n"
                                      "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                      "24.715 1.77 26.086 3.398 26.086 c 71.109 26.086 l 72.738 26.086 74.109 24.715\n"
                                      " 74.109 23.086 c 74.109 3.398 l 74.109 1.77 72.738 0.398 71.109 0.398 c \n"
                                      "h\n"
                                      "3.867 3.844 m 70.664 3.844 l 70.664 22.617 l 3.867 22.617 l h\n"
                                      "3.867 3.844 m B Q\n"
                                      "Q\n";

static std::unique_ptr<Dict> getSoldStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
