//========================================================================
//
// annot_stamp_not_approved.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_NOT_APPROVED_H
#define ANNOT_STAMP_NOT_APPROVED_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_NOT_APPROVED_WIDTH = 170.508179;
static const double ANNOT_STAMP_NOT_APPROVED_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_NOT_APPROVED = "1 0 0 -1 0 26.484741 cm\n"
                                              "q\n"
                                              "1 1 1 rg /a0 gs\n"
                                              "3.406 2.129 m 167.117 2.129 l 167.816 2.129 168.387 2.828 168.387 3.398\n"
                                              " c 168.387 23.09 l 168.387 23.789 167.82 24.359 167.117 24.359 c 3.406 24.359\n"
                                              " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                              " 2.129 3.406 2.129 c h\n"
                                              "3.406 2.129 m f\n"
                                              "0.74902 0 0 rg /a1 gs\n"
                                              "24.195 20.828 m 17.484 8.973 l 17.52 9.293 17.555 9.613 17.582 9.934 c \n"
                                              "17.609 10.211 17.633 10.508 17.648 10.828 c 17.672 11.148 17.68 11.453 17.68\n"
                                              " 11.746 c 17.68 20.828 l 14.82 20.828 l 14.82 5.434 l 18.504 5.434 l 25.312\n"
                                              " 17.387 l 25.277 17.082 25.242 16.762 25.215 16.426 c 25.188 16.141 25.16\n"
                                              " 15.82 25.137 15.465 c 25.121 15.109 25.113 14.746 25.113 14.383 c 25.113\n"
                                              " 5.434 l 27.977 5.434 l 27.977 20.828 l 24.195 20.828 l 42.289 14.906 m \n"
                                              "42.289 15.809 42.16 16.637 41.906 17.387 c 41.66 18.137 41.285 18.785 40.781\n"
                                              " 19.332 c 40.277 19.871 39.652 20.293 38.902 20.598 c 38.152 20.895 37.277\n"
                                              " 21.047 36.281 21.047 c 35.32 21.047 34.473 20.898 33.734 20.598 c 33 20.301\n"
                                              " 32.379 19.879 31.875 19.34 c 31.379 18.801 31.004 18.156 30.75 17.406 c\n"
                                              " 30.496 16.648 30.367 15.816 30.367 14.902 c 30.367 14.02 30.488 13.207 \n"
                                              "30.727 12.465 c 30.973 11.715 31.348 11.066 31.84 10.52 c 32.336 9.973 32.957\n"
                                              " 9.547 33.707 9.242 c 34.457 8.938 35.336 8.785 36.34 8.785 c 37.402 8.785\n"
                                              " 38.309 8.938 39.062 9.242 c 39.812 9.547 40.426 9.973 40.898 10.52 c 41.379\n"
                                              " 11.059 41.73 11.703 41.949 12.453 c 42.176 13.195 42.289 14.012 42.289 \n"
                                              "14.902 c 39.078 14.902 m 39.078 13.496 38.848 12.477 38.391 11.844 c 37.934\n"
                                              " 11.211 37.266 10.895 36.391 10.895 c 35.488 10.895 34.797 11.215 34.316\n"
                                              " 11.855 c 33.836 12.496 33.594 13.512 33.594 14.902 c 33.594 15.609 33.656\n"
                                              " 16.219 33.781 16.727 c 33.914 17.238 34.094 17.656 34.328 17.984 c 34.562\n"
                                              " 18.312 34.84 18.555 35.168 18.715 c 35.496 18.867 35.855 18.945 36.25 18.945\n"
                                              " c 36.703 18.945 37.102 18.867 37.453 18.715 c 37.809 18.555 38.109 18.312\n"
                                              " 38.348 17.984 c 38.59 17.656 38.77 17.238 38.895 16.727 c 39.02 16.215 \n"
                                              "39.082 15.609 39.082 14.902 c 47.77 21.02 m 46.867 21.02 46.172 20.777 45.684\n"
                                              " 20.289 c 45.195 19.793 44.953 19.047 44.953 18.051 c 44.953 11.078 l 43.449\n"
                                              " 11.082 l 43.449 9.008 l 45.098 9.008 l 46.059 6.23 l 47.98 6.23 l 47.98\n"
                                              " 9.008 l 50.219 9.008 l 50.219 11.082 l 47.98 11.082 l 47.98 17.223 l 47.98\n"
                                              " 17.797 48.09 18.223 48.309 18.5 c 48.527 18.77 48.867 18.906 49.324 18.902\n"
                                              " c 49.512 18.902 49.684 18.887 49.836 18.859 c 49.988 18.832 50.16 18.793\n"
                                              " 50.348 18.75 c 50.348 20.652 l 49.969 20.777 49.566 20.867 49.145 20.926\n"
                                              " c 48.723 20.992 48.258 21.023 47.758 21.023 c 68.398 20.828 m 67.031 16.895\n"
                                              " l 61.164 16.895 l 59.797 20.828 l 56.574 20.828 l 62.191 5.434 l 65.992\n"
                                              " 5.434 l 71.586 20.828 l 68.395 20.828 l 64.789 10.043 m 64.703 9.789 64.613\n"
                                              " 9.531 64.527 9.277 c 64.445 9.016 64.375 8.777 64.309 8.566 c 64.25 8.348\n"
                                              " 64.199 8.168 64.156 8.031 c 64.121 7.895 64.098 7.816 64.09 7.801 c 64.082\n"
                                              " 7.824 64.062 7.902 64.023 8.043 c 63.988 8.18 63.938 8.355 63.871 8.566\n"
                                              " c 63.812 8.777 63.738 9.016 63.652 9.277 c 63.57 9.531 63.488 9.789 63.402\n"
                                              " 10.043 c 61.883 14.469 l 66.309 14.469 l 64.789 10.043 l 84.938 14.863 \n"
                                              "m 84.938 15.758 84.848 16.586 84.664 17.344 c 84.488 18.102 84.215 18.754\n"
                                              " 83.844 19.301 c 83.473 19.848 83 20.277 82.422 20.59 c 81.855 20.895 81.18\n"
                                              " 21.047 80.402 21.047 c 80.051 21.047 79.703 21.012 79.352 20.938 c 79.008\n"
                                              " 20.863 78.68 20.75 78.367 20.586 c 78.055 20.418 77.762 20.203 77.492 19.941\n"
                                              " c 77.23 19.672 77.004 19.34 76.816 18.945 c 76.75 18.945 l 76.758 18.98\n"
                                              " 76.766 19.074 76.773 19.219 c 76.781 19.363 76.789 19.535 76.797 19.73 \n"
                                              "c 76.805 19.918 76.809 20.125 76.809 20.344 c 76.816 20.555 76.82 20.75 \n"
                                              "76.82 20.934 c 76.82 25.469 l 73.75 25.469 l 73.75 11.723 l 73.75 11.117\n"
                                              " 73.738 10.578 73.719 10.105 c 73.703 9.633 73.688 9.266 73.664 9 c 76.648\n"
                                              " 9 l 76.664 9.051 76.676 9.148 76.691 9.297 c 76.715 9.441 76.727 9.609 \n"
                                              "76.734 9.801 c 76.75 9.988 76.762 10.188 76.766 10.391 c 76.773 10.594 76.777\n"
                                              " 10.773 76.777 10.926 c 76.82 10.926 l 77.191 10.145 77.703 9.59 78.352 \n"
                                              "9.254 c 79 8.918 79.75 8.75 80.602 8.75 c 81.352 8.75 82 8.902 82.547 9.207\n"
                                              " c 83.094 9.512 83.543 9.934 83.891 10.473 c 84.246 11.012 84.512 11.656\n"
                                              " 84.676 12.406 c 84.852 13.148 84.938 13.965 84.938 14.855 c 81.734 14.855\n"
                                              " m 81.734 13.508 81.531 12.512 81.121 11.863 c 80.715 11.207 80.105 10.879\n"
                                              " 79.297 10.879 c 78.992 10.879 78.684 10.945 78.379 11.074 c 78.082 11.199\n"
                                              " 77.812 11.418 77.57 11.73 c 77.336 12.035 77.145 12.453 76.992 12.977 c\n"
                                              " 76.848 13.492 76.773 14.148 76.773 14.945 c 76.773 15.719 76.848 16.363\n"
                                              " 76.992 16.879 c 77.137 17.391 77.328 17.797 77.559 18.102 c 77.801 18.406\n"
                                              " 78.07 18.625 78.367 18.758 c 78.664 18.883 78.969 18.945 79.273 18.945 \n"
                                              "c 79.668 18.945 80.016 18.867 80.324 18.715 c 80.629 18.555 80.887 18.312\n"
                                              " 81.09 17.984 c 81.301 17.648 81.461 17.223 81.57 16.707 c 81.68 16.191 \n"
                                              "81.734 15.574 81.734 14.859 c 98.617 14.859 m 98.617 15.754 98.527 16.582\n"
                                              " 98.344 17.34 c 98.168 18.098 97.895 18.75 97.523 19.297 c 97.152 19.844\n"
                                              " 96.68 20.273 96.102 20.586 c 95.535 20.891 94.859 21.043 94.082 21.043 \n"
                                              "c 93.73 21.043 93.383 21.008 93.031 20.934 c 92.688 20.859 92.359 20.746\n"
                                              " 92.047 20.582 c 91.734 20.414 91.441 20.199 91.172 19.938 c 90.91 19.668\n"
                                              " 90.684 19.336 90.496 18.941 c 90.43 18.941 l 90.438 18.977 90.445 19.07\n"
                                              " 90.453 19.215 c 90.461 19.359 90.469 19.531 90.477 19.727 c 90.484 19.914\n"
                                              " 90.488 20.121 90.488 20.34 c 90.496 20.551 90.5 20.746 90.5 20.93 c 90.5\n"
                                              " 25.465 l 87.43 25.465 l 87.43 11.719 l 87.43 11.113 87.418 10.574 87.398\n"
                                              " 10.102 c 87.383 9.629 87.367 9.262 87.344 8.996 c 90.328 8.996 l 90.344\n"
                                              " 9.047 90.355 9.145 90.371 9.293 c 90.395 9.438 90.406 9.605 90.414 9.797\n"
                                              " c 90.43 9.984 90.441 10.184 90.445 10.387 c 90.453 10.59 90.457 10.77 90.457\n"
                                              " 10.922 c 90.5 10.922 l 90.871 10.141 91.383 9.586 92.031 9.25 c 92.68 8.914\n"
                                              " 93.43 8.746 94.281 8.746 c 95.031 8.746 95.68 8.898 96.227 9.203 c 96.773\n"
                                              " 9.508 97.223 9.93 97.57 10.469 c 97.926 11.008 98.191 11.652 98.355 12.402\n"
                                              " c 98.531 13.145 98.617 13.961 98.617 14.852 c 95.414 14.852 m 95.414 13.504\n"
                                              " 95.211 12.508 94.801 11.859 c 94.395 11.203 93.785 10.875 92.977 10.875\n"
                                              " c 92.672 10.875 92.363 10.941 92.059 11.07 c 91.762 11.195 91.492 11.414\n"
                                              " 91.25 11.727 c 91.016 12.031 90.824 12.449 90.672 12.973 c 90.527 13.488\n"
                                              " 90.453 14.145 90.453 14.941 c 90.453 15.715 90.527 16.359 90.672 16.875\n"
                                              " c 90.816 17.387 91.008 17.793 91.238 18.098 c 91.48 18.402 91.75 18.621\n"
                                              " 92.047 18.754 c 92.344 18.879 92.648 18.941 92.953 18.941 c 93.348 18.941\n"
                                              " 93.695 18.863 94.004 18.711 c 94.309 18.551 94.566 18.309 94.77 17.98 c\n"
                                              " 94.98 17.645 95.141 17.219 95.25 16.703 c 95.359 16.188 95.414 15.57 95.414\n"
                                              " 14.855 c 101.105 20.82 m 101.105 11.773 l 101.105 11.52 101.102 11.25 101.094\n"
                                              " 10.965 c 101.094 10.68 101.086 10.41 101.07 10.156 c 101.062 9.895 101.055\n"
                                              " 9.66 101.047 9.457 c 101.039 9.246 101.027 9.094 101.016 9 c 103.945 9 \n"
                                              "l 103.961 9.086 103.973 9.242 103.988 9.457 c 104.004 9.668 104.016 9.902\n"
                                              " 104.031 10.156 c 104.047 10.41 104.059 10.668 104.062 10.922 c 104.078 \n"
                                              "11.168 104.086 11.371 104.086 11.523 c 104.129 11.523 l 104.281 11.094 104.434\n"
                                              " 10.711 104.586 10.375 c 104.738 10.031 104.918 9.746 105.121 9.512 c 105.332\n"
                                              " 9.27 105.582 9.09 105.875 8.965 c 106.168 8.832 106.527 8.77 106.957 8.77\n"
                                              " c 107.141 8.77 107.316 8.789 107.492 8.824 c 107.676 8.852 107.812 8.891\n"
                                              " 107.906 8.934 c 107.906 11.5 l 107.711 11.457 107.508 11.418 107.305 11.391\n"
                                              " c 107.109 11.355 106.871 11.336 106.594 11.336 c 105.828 11.336 105.23 \n"
                                              "11.645 104.801 12.266 c 104.379 12.887 104.168 13.801 104.168 15.02 c 104.168\n"
                                              " 20.82 l 101.098 20.82 l 121.027 14.898 m 121.027 15.801 120.898 16.629 \n"
                                              "120.645 17.379 c 120.398 18.129 120.023 18.777 119.52 19.324 c 119.016 19.863\n"
                                              " 118.391 20.285 117.641 20.59 c 116.891 20.887 116.016 21.039 115.02 21.039\n"
                                              " c 114.059 21.039 113.211 20.891 112.473 20.59 c 111.738 20.293 111.117 \n"
                                              "19.871 110.613 19.332 c 110.117 18.793 109.742 18.148 109.488 17.398 c 109.234\n"
                                              " 16.641 109.105 15.809 109.105 14.895 c 109.105 14.012 109.227 13.199 109.465\n"
                                              " 12.457 c 109.711 11.707 110.086 11.059 110.578 10.512 c 111.074 9.965 111.695\n"
                                              " 9.539 112.445 9.234 c 113.195 8.93 114.074 8.777 115.078 8.777 c 116.141\n"
                                              " 8.777 117.047 8.93 117.801 9.234 c 118.551 9.539 119.164 9.965 119.637 \n"
                                              "10.512 c 120.117 11.051 120.469 11.695 120.688 12.445 c 120.914 13.188 121.027\n"
                                              " 14.004 121.027 14.895 c 117.816 14.895 m 117.816 13.488 117.586 12.469 \n"
                                              "117.129 11.836 c 116.672 11.203 116.004 10.887 115.129 10.887 c 114.227 \n"
                                              "10.887 113.535 11.207 113.055 11.848 c 112.574 12.488 112.332 13.504 112.332\n"
                                              " 14.895 c 112.332 15.602 112.395 16.211 112.52 16.719 c 112.652 17.23 112.832\n"
                                              " 17.648 113.066 17.977 c 113.301 18.305 113.578 18.547 113.906 18.707 c \n"
                                              "114.234 18.859 114.594 18.938 114.988 18.938 c 115.441 18.938 115.84 18.859\n"
                                              " 116.191 18.707 c 116.547 18.547 116.848 18.305 117.086 17.977 c 117.328\n"
                                              " 17.648 117.508 17.23 117.633 16.719 c 117.758 16.207 117.82 15.602 117.82\n"
                                              " 14.895 c 129.906 20.816 m 126.234 20.816 l 122.004 8.992 l 125.25 8.992\n"
                                              " l 127.316 15.602 l 127.383 15.82 127.449 16.055 127.523 16.301 c 127.598\n"
                                              " 16.543 127.664 16.781 127.73 17.023 c 127.797 17.266 127.859 17.496 127.918\n"
                                              " 17.723 c 127.984 17.949 128.043 18.152 128.094 18.336 c 128.137 18.16 128.191\n"
                                              " 17.965 128.258 17.746 c 128.324 17.52 128.391 17.289 128.453 17.047 c 128.527\n"
                                              " 16.805 128.598 16.566 128.672 16.324 c 128.754 16.082 128.828 15.855 128.902\n"
                                              " 15.637 c 131.055 8.992 l 134.266 8.992 l 129.906 20.816 l 140.777 21.035\n"
                                              " m 139.926 21.035 139.156 20.91 138.473 20.664 c 137.797 20.41 137.215 20.027\n"
                                              " 136.734 19.516 c 136.254 19 135.887 18.355 135.629 17.582 c 135.375 16.801\n"
                                              " 135.246 15.891 135.246 14.852 c 135.246 13.723 135.395 12.773 135.695 12\n"
                                              " c 136 11.227 136.41 10.605 136.918 10.133 c 137.434 9.652 138.027 9.305\n"
                                              " 138.699 9.094 c 139.371 8.883 140.074 8.777 140.82 8.777 c 141.754 8.777\n"
                                              " 142.547 8.941 143.203 9.27 c 143.867 9.59 144.41 10.043 144.832 10.625 \n"
                                              "c 145.254 11.207 145.562 11.906 145.762 12.723 c 145.957 13.531 146.059 \n"
                                              "14.426 146.059 15.41 c 146.059 15.496 l 138.477 15.496 l 138.477 15.992 \n"
                                              "138.52 16.453 138.609 16.883 c 138.695 17.305 138.84 17.672 139.035 17.988\n"
                                              " c 139.23 18.293 139.488 18.539 139.801 18.719 c 140.113 18.895 140.492 \n"
                                              "18.98 140.938 18.98 c 141.477 18.98 141.918 18.867 142.258 18.641 c 142.602\n"
                                              " 18.406 142.844 18.051 142.988 17.57 c 145.883 17.82 l 145.75 18.156 145.566\n"
                                              " 18.512 145.324 18.891 c 145.09 19.27 144.777 19.617 144.383 19.941 c 143.988\n"
                                              " 20.254 143.496 20.516 142.906 20.727 c 142.324 20.93 141.613 21.031 140.777\n"
                                              " 21.031 c 140.777 10.707 m 140.465 10.707 140.168 10.762 139.891 10.871 \n"
                                              "c 139.621 10.973 139.383 11.141 139.18 11.375 c 138.984 11.602 138.824 11.895\n"
                                              " 138.699 12.262 c 138.574 12.625 138.508 13.062 138.492 13.574 c 143.082\n"
                                              " 13.574 l 143.023 12.621 142.793 11.906 142.395 11.434 c 141.992 10.953 \n"
                                              "141.453 10.711 140.777 10.711 c 156.055 20.816 m 156.039 20.758 156.023 \n"
                                              "20.656 156 20.512 c 155.984 20.359 155.969 20.188 155.945 20 c 155.93 19.812\n"
                                              " 155.918 19.617 155.902 19.422 c 155.895 19.227 155.891 19.051 155.891 18.898\n"
                                              " c 155.848 18.898 l 155.492 19.664 154.992 20.215 154.352 20.547 c 153.719\n"
                                              " 20.875 152.957 21.039 152.066 21.039 c 151.324 21.039 150.68 20.887 150.133\n"
                                              " 20.582 c 149.594 20.277 149.145 19.852 148.789 19.305 c 148.438 18.758 \n"
                                              "148.176 18.113 148.004 17.371 c 147.836 16.621 147.754 15.805 147.754 14.922\n"
                                              " c 147.754 14.027 147.84 13.203 148.016 12.453 c 148.199 11.703 148.473 \n"
                                              "11.059 148.848 10.52 c 149.219 9.973 149.688 9.547 150.258 9.242 c 150.832\n"
                                              " 8.938 151.516 8.785 152.301 8.785 c 152.688 8.785 153.059 8.824 153.414\n"
                                              " 8.906 c 153.77 8.988 154.102 9.109 154.41 9.277 c 154.715 9.445 154.992\n"
                                              " 9.66 155.242 9.922 c 155.488 10.184 155.699 10.5 155.875 10.871 c 155.898\n"
                                              " 10.871 l 155.898 10.797 155.895 10.691 155.887 10.555 c 155.887 10.41 155.887\n"
                                              " 10.246 155.887 10.062 c 155.887 9.879 155.883 9.691 155.875 9.496 c 155.875\n"
                                              " 9.301 155.875 9.109 155.875 8.93 c 155.875 4.613 l 158.945 4.613 l 158.945\n"
                                              " 18.25 l 158.945 18.824 158.957 19.34 158.977 19.789 c 159 20.234 159.016\n"
                                              " 20.578 159.031 20.828 c 156.059 20.828 l 155.918 14.852 m 155.918 14.07\n"
                                              " 155.844 13.426 155.699 12.918 c 155.555 12.402 155.359 11.992 155.121 11.695\n"
                                              " c 154.887 11.391 154.617 11.18 154.312 11.062 c 154.016 10.938 153.707 \n"
                                              "10.875 153.395 10.875 c 153 10.875 152.652 10.953 152.344 11.105 c 152.047\n"
                                              " 11.258 151.789 11.5 151.578 11.828 c 151.375 12.156 151.219 12.574 151.109\n"
                                              " 13.086 c 151.008 13.598 150.957 14.211 150.957 14.934 c 150.957 17.613 \n"
                                              "151.762 18.953 153.371 18.953 c 153.676 18.953 153.984 18.887 154.289 18.758\n"
                                              " c 154.594 18.625 154.867 18.406 155.109 18.09 c 155.352 17.777 155.543 \n"
                                              "17.359 155.688 16.832 c 155.84 16.301 155.918 15.641 155.918 14.855 c f\n"
                                              "1 1 1 RG 0.531496 w\n"
                                              "0 J\n"
                                              "0 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "24.195 20.828 m 17.484 8.973 l 17.52 9.293 17.555 9.613 17.582 9.934 c \n"
                                              "17.609 10.211 17.633 10.508 17.648 10.828 c 17.672 11.148 17.68 11.453 17.68\n"
                                              " 11.746 c 17.68 20.828 l 14.82 20.828 l 14.82 5.434 l 18.504 5.434 l 25.312\n"
                                              " 17.387 l 25.277 17.082 25.242 16.762 25.215 16.426 c 25.188 16.141 25.16\n"
                                              " 15.82 25.137 15.465 c 25.121 15.109 25.113 14.746 25.113 14.383 c 25.113\n"
                                              " 5.434 l 27.977 5.434 l 27.977 20.828 l 24.195 20.828 l 42.289 14.906 m \n"
                                              "42.289 15.809 42.16 16.637 41.906 17.387 c 41.66 18.137 41.285 18.785 40.781\n"
                                              " 19.332 c 40.277 19.871 39.652 20.293 38.902 20.598 c 38.152 20.895 37.277\n"
                                              " 21.047 36.281 21.047 c 35.32 21.047 34.473 20.898 33.734 20.598 c 33 20.301\n"
                                              " 32.379 19.879 31.875 19.34 c 31.379 18.801 31.004 18.156 30.75 17.406 c\n"
                                              " 30.496 16.648 30.367 15.816 30.367 14.902 c 30.367 14.02 30.488 13.207 \n"
                                              "30.727 12.465 c 30.973 11.715 31.348 11.066 31.84 10.52 c 32.336 9.973 32.957\n"
                                              " 9.547 33.707 9.242 c 34.457 8.938 35.336 8.785 36.34 8.785 c 37.402 8.785\n"
                                              " 38.309 8.938 39.062 9.242 c 39.812 9.547 40.426 9.973 40.898 10.52 c 41.379\n"
                                              " 11.059 41.73 11.703 41.949 12.453 c 42.176 13.195 42.289 14.012 42.289 \n"
                                              "14.902 c 39.078 14.902 m 39.078 13.496 38.848 12.477 38.391 11.844 c 37.934\n"
                                              " 11.211 37.266 10.895 36.391 10.895 c 35.488 10.895 34.797 11.215 34.316\n"
                                              " 11.855 c 33.836 12.496 33.594 13.512 33.594 14.902 c 33.594 15.609 33.656\n"
                                              " 16.219 33.781 16.727 c 33.914 17.238 34.094 17.656 34.328 17.984 c 34.562\n"
                                              " 18.312 34.84 18.555 35.168 18.715 c 35.496 18.867 35.855 18.945 36.25 18.945\n"
                                              " c 36.703 18.945 37.102 18.867 37.453 18.715 c 37.809 18.555 38.109 18.312\n"
                                              " 38.348 17.984 c 38.59 17.656 38.77 17.238 38.895 16.727 c 39.02 16.215 \n"
                                              "39.082 15.609 39.082 14.902 c 47.77 21.02 m 46.867 21.02 46.172 20.777 45.684\n"
                                              " 20.289 c 45.195 19.793 44.953 19.047 44.953 18.051 c 44.953 11.078 l 43.449\n"
                                              " 11.082 l 43.449 9.008 l 45.098 9.008 l 46.059 6.23 l 47.98 6.23 l 47.98\n"
                                              " 9.008 l 50.219 9.008 l 50.219 11.082 l 47.98 11.082 l 47.98 17.223 l 47.98\n"
                                              " 17.797 48.09 18.223 48.309 18.5 c 48.527 18.77 48.867 18.906 49.324 18.902\n"
                                              " c 49.512 18.902 49.684 18.887 49.836 18.859 c 49.988 18.832 50.16 18.793\n"
                                              " 50.348 18.75 c 50.348 20.652 l 49.969 20.777 49.566 20.867 49.145 20.926\n"
                                              " c 48.723 20.992 48.258 21.023 47.758 21.023 c 68.398 20.828 m 67.031 16.895\n"
                                              " l 61.164 16.895 l 59.797 20.828 l 56.574 20.828 l 62.191 5.434 l 65.992\n"
                                              " 5.434 l 71.586 20.828 l 68.395 20.828 l 64.789 10.043 m 64.703 9.789 64.613\n"
                                              " 9.531 64.527 9.277 c 64.445 9.016 64.375 8.777 64.309 8.566 c 64.25 8.348\n"
                                              " 64.199 8.168 64.156 8.031 c 64.121 7.895 64.098 7.816 64.09 7.801 c 64.082\n"
                                              " 7.824 64.062 7.902 64.023 8.043 c 63.988 8.18 63.938 8.355 63.871 8.566\n"
                                              " c 63.812 8.777 63.738 9.016 63.652 9.277 c 63.57 9.531 63.488 9.789 63.402\n"
                                              " 10.043 c 61.883 14.469 l 66.309 14.469 l 64.789 10.043 l 84.938 14.863 \n"
                                              "m 84.938 15.758 84.848 16.586 84.664 17.344 c 84.488 18.102 84.215 18.754\n"
                                              " 83.844 19.301 c 83.473 19.848 83 20.277 82.422 20.59 c 81.855 20.895 81.18\n"
                                              " 21.047 80.402 21.047 c 80.051 21.047 79.703 21.012 79.352 20.938 c 79.008\n"
                                              " 20.863 78.68 20.75 78.367 20.586 c 78.055 20.418 77.762 20.203 77.492 19.941\n"
                                              " c 77.23 19.672 77.004 19.34 76.816 18.945 c 76.75 18.945 l 76.758 18.98\n"
                                              " 76.766 19.074 76.773 19.219 c 76.781 19.363 76.789 19.535 76.797 19.73 \n"
                                              "c 76.805 19.918 76.809 20.125 76.809 20.344 c 76.816 20.555 76.82 20.75 \n"
                                              "76.82 20.934 c 76.82 25.469 l 73.75 25.469 l 73.75 11.723 l 73.75 11.117\n"
                                              " 73.738 10.578 73.719 10.105 c 73.703 9.633 73.688 9.266 73.664 9 c 76.648\n"
                                              " 9 l 76.664 9.051 76.676 9.148 76.691 9.297 c 76.715 9.441 76.727 9.609 \n"
                                              "76.734 9.801 c 76.75 9.988 76.762 10.188 76.766 10.391 c 76.773 10.594 76.777\n"
                                              " 10.773 76.777 10.926 c 76.82 10.926 l 77.191 10.145 77.703 9.59 78.352 \n"
                                              "9.254 c 79 8.918 79.75 8.75 80.602 8.75 c 81.352 8.75 82 8.902 82.547 9.207\n"
                                              " c 83.094 9.512 83.543 9.934 83.891 10.473 c 84.246 11.012 84.512 11.656\n"
                                              " 84.676 12.406 c 84.852 13.148 84.938 13.965 84.938 14.855 c 81.734 14.855\n"
                                              " m 81.734 13.508 81.531 12.512 81.121 11.863 c 80.715 11.207 80.105 10.879\n"
                                              " 79.297 10.879 c 78.992 10.879 78.684 10.945 78.379 11.074 c 78.082 11.199\n"
                                              " 77.812 11.418 77.57 11.73 c 77.336 12.035 77.145 12.453 76.992 12.977 c\n"
                                              " 76.848 13.492 76.773 14.148 76.773 14.945 c 76.773 15.719 76.848 16.363\n"
                                              " 76.992 16.879 c 77.137 17.391 77.328 17.797 77.559 18.102 c 77.801 18.406\n"
                                              " 78.07 18.625 78.367 18.758 c 78.664 18.883 78.969 18.945 79.273 18.945 \n"
                                              "c 79.668 18.945 80.016 18.867 80.324 18.715 c 80.629 18.555 80.887 18.312\n"
                                              " 81.09 17.984 c 81.301 17.648 81.461 17.223 81.57 16.707 c 81.68 16.191 \n"
                                              "81.734 15.574 81.734 14.859 c 98.617 14.859 m 98.617 15.754 98.527 16.582\n"
                                              " 98.344 17.34 c 98.168 18.098 97.895 18.75 97.523 19.297 c 97.152 19.844\n"
                                              " 96.68 20.273 96.102 20.586 c 95.535 20.891 94.859 21.043 94.082 21.043 \n"
                                              "c 93.73 21.043 93.383 21.008 93.031 20.934 c 92.688 20.859 92.359 20.746\n"
                                              " 92.047 20.582 c 91.734 20.414 91.441 20.199 91.172 19.938 c 90.91 19.668\n"
                                              " 90.684 19.336 90.496 18.941 c 90.43 18.941 l 90.438 18.977 90.445 19.07\n"
                                              " 90.453 19.215 c 90.461 19.359 90.469 19.531 90.477 19.727 c 90.484 19.914\n"
                                              " 90.488 20.121 90.488 20.34 c 90.496 20.551 90.5 20.746 90.5 20.93 c 90.5\n"
                                              " 25.465 l 87.43 25.465 l 87.43 11.719 l 87.43 11.113 87.418 10.574 87.398\n"
                                              " 10.102 c 87.383 9.629 87.367 9.262 87.344 8.996 c 90.328 8.996 l 90.344\n"
                                              " 9.047 90.355 9.145 90.371 9.293 c 90.395 9.438 90.406 9.605 90.414 9.797\n"
                                              " c 90.43 9.984 90.441 10.184 90.445 10.387 c 90.453 10.59 90.457 10.77 90.457\n"
                                              " 10.922 c 90.5 10.922 l 90.871 10.141 91.383 9.586 92.031 9.25 c 92.68 8.914\n"
                                              " 93.43 8.746 94.281 8.746 c 95.031 8.746 95.68 8.898 96.227 9.203 c 96.773\n"
                                              " 9.508 97.223 9.93 97.57 10.469 c 97.926 11.008 98.191 11.652 98.355 12.402\n"
                                              " c 98.531 13.145 98.617 13.961 98.617 14.852 c 95.414 14.852 m 95.414 13.504\n"
                                              " 95.211 12.508 94.801 11.859 c 94.395 11.203 93.785 10.875 92.977 10.875\n"
                                              " c 92.672 10.875 92.363 10.941 92.059 11.07 c 91.762 11.195 91.492 11.414\n"
                                              " 91.25 11.727 c 91.016 12.031 90.824 12.449 90.672 12.973 c 90.527 13.488\n"
                                              " 90.453 14.145 90.453 14.941 c 90.453 15.715 90.527 16.359 90.672 16.875\n"
                                              " c 90.816 17.387 91.008 17.793 91.238 18.098 c 91.48 18.402 91.75 18.621\n"
                                              " 92.047 18.754 c 92.344 18.879 92.648 18.941 92.953 18.941 c 93.348 18.941\n"
                                              " 93.695 18.863 94.004 18.711 c 94.309 18.551 94.566 18.309 94.77 17.98 c\n"
                                              " 94.98 17.645 95.141 17.219 95.25 16.703 c 95.359 16.188 95.414 15.57 95.414\n"
                                              " 14.855 c 101.105 20.82 m 101.105 11.773 l 101.105 11.52 101.102 11.25 101.094\n"
                                              " 10.965 c 101.094 10.68 101.086 10.41 101.07 10.156 c 101.062 9.895 101.055\n"
                                              " 9.66 101.047 9.457 c 101.039 9.246 101.027 9.094 101.016 9 c 103.945 9 \n"
                                              "l 103.961 9.086 103.973 9.242 103.988 9.457 c 104.004 9.668 104.016 9.902\n"
                                              " 104.031 10.156 c 104.047 10.41 104.059 10.668 104.062 10.922 c 104.078 \n"
                                              "11.168 104.086 11.371 104.086 11.523 c 104.129 11.523 l 104.281 11.094 104.434\n"
                                              " 10.711 104.586 10.375 c 104.738 10.031 104.918 9.746 105.121 9.512 c 105.332\n"
                                              " 9.27 105.582 9.09 105.875 8.965 c 106.168 8.832 106.527 8.77 106.957 8.77\n"
                                              " c 107.141 8.77 107.316 8.789 107.492 8.824 c 107.676 8.852 107.812 8.891\n"
                                              " 107.906 8.934 c 107.906 11.5 l 107.711 11.457 107.508 11.418 107.305 11.391\n"
                                              " c 107.109 11.355 106.871 11.336 106.594 11.336 c 105.828 11.336 105.23 \n"
                                              "11.645 104.801 12.266 c 104.379 12.887 104.168 13.801 104.168 15.02 c 104.168\n"
                                              " 20.82 l 101.098 20.82 l 121.027 14.898 m 121.027 15.801 120.898 16.629 \n"
                                              "120.645 17.379 c 120.398 18.129 120.023 18.777 119.52 19.324 c 119.016 19.863\n"
                                              " 118.391 20.285 117.641 20.59 c 116.891 20.887 116.016 21.039 115.02 21.039\n"
                                              " c 114.059 21.039 113.211 20.891 112.473 20.59 c 111.738 20.293 111.117 \n"
                                              "19.871 110.613 19.332 c 110.117 18.793 109.742 18.148 109.488 17.398 c 109.234\n"
                                              " 16.641 109.105 15.809 109.105 14.895 c 109.105 14.012 109.227 13.199 109.465\n"
                                              " 12.457 c 109.711 11.707 110.086 11.059 110.578 10.512 c 111.074 9.965 111.695\n"
                                              " 9.539 112.445 9.234 c 113.195 8.93 114.074 8.777 115.078 8.777 c 116.141\n"
                                              " 8.777 117.047 8.93 117.801 9.234 c 118.551 9.539 119.164 9.965 119.637 \n"
                                              "10.512 c 120.117 11.051 120.469 11.695 120.688 12.445 c 120.914 13.188 121.027\n"
                                              " 14.004 121.027 14.895 c 117.816 14.895 m 117.816 13.488 117.586 12.469 \n"
                                              "117.129 11.836 c 116.672 11.203 116.004 10.887 115.129 10.887 c 114.227 \n"
                                              "10.887 113.535 11.207 113.055 11.848 c 112.574 12.488 112.332 13.504 112.332\n"
                                              " 14.895 c 112.332 15.602 112.395 16.211 112.52 16.719 c 112.652 17.23 112.832\n"
                                              " 17.648 113.066 17.977 c 113.301 18.305 113.578 18.547 113.906 18.707 c \n"
                                              "114.234 18.859 114.594 18.938 114.988 18.938 c 115.441 18.938 115.84 18.859\n"
                                              " 116.191 18.707 c 116.547 18.547 116.848 18.305 117.086 17.977 c 117.328\n"
                                              " 17.648 117.508 17.23 117.633 16.719 c 117.758 16.207 117.82 15.602 117.82\n"
                                              " 14.895 c 129.906 20.816 m 126.234 20.816 l 122.004 8.992 l 125.25 8.992\n"
                                              " l 127.316 15.602 l 127.383 15.82 127.449 16.055 127.523 16.301 c 127.598\n"
                                              " 16.543 127.664 16.781 127.73 17.023 c 127.797 17.266 127.859 17.496 127.918\n"
                                              " 17.723 c 127.984 17.949 128.043 18.152 128.094 18.336 c 128.137 18.16 128.191\n"
                                              " 17.965 128.258 17.746 c 128.324 17.52 128.391 17.289 128.453 17.047 c 128.527\n"
                                              " 16.805 128.598 16.566 128.672 16.324 c 128.754 16.082 128.828 15.855 128.902\n"
                                              " 15.637 c 131.055 8.992 l 134.266 8.992 l 129.906 20.816 l 140.777 21.035\n"
                                              " m 139.926 21.035 139.156 20.91 138.473 20.664 c 137.797 20.41 137.215 20.027\n"
                                              " 136.734 19.516 c 136.254 19 135.887 18.355 135.629 17.582 c 135.375 16.801\n"
                                              " 135.246 15.891 135.246 14.852 c 135.246 13.723 135.395 12.773 135.695 12\n"
                                              " c 136 11.227 136.41 10.605 136.918 10.133 c 137.434 9.652 138.027 9.305\n"
                                              " 138.699 9.094 c 139.371 8.883 140.074 8.777 140.82 8.777 c 141.754 8.777\n"
                                              " 142.547 8.941 143.203 9.27 c 143.867 9.59 144.41 10.043 144.832 10.625 \n"
                                              "c 145.254 11.207 145.562 11.906 145.762 12.723 c 145.957 13.531 146.059 \n"
                                              "14.426 146.059 15.41 c 146.059 15.496 l 138.477 15.496 l 138.477 15.992 \n"
                                              "138.52 16.453 138.609 16.883 c 138.695 17.305 138.84 17.672 139.035 17.988\n"
                                              " c 139.23 18.293 139.488 18.539 139.801 18.719 c 140.113 18.895 140.492 \n"
                                              "18.98 140.938 18.98 c 141.477 18.98 141.918 18.867 142.258 18.641 c 142.602\n"
                                              " 18.406 142.844 18.051 142.988 17.57 c 145.883 17.82 l 145.75 18.156 145.566\n"
                                              " 18.512 145.324 18.891 c 145.09 19.27 144.777 19.617 144.383 19.941 c 143.988\n"
                                              " 20.254 143.496 20.516 142.906 20.727 c 142.324 20.93 141.613 21.031 140.777\n"
                                              " 21.031 c 140.777 10.707 m 140.465 10.707 140.168 10.762 139.891 10.871 \n"
                                              "c 139.621 10.973 139.383 11.141 139.18 11.375 c 138.984 11.602 138.824 11.895\n"
                                              " 138.699 12.262 c 138.574 12.625 138.508 13.062 138.492 13.574 c 143.082\n"
                                              " 13.574 l 143.023 12.621 142.793 11.906 142.395 11.434 c 141.992 10.953 \n"
                                              "141.453 10.711 140.777 10.711 c 156.055 20.816 m 156.039 20.758 156.023 \n"
                                              "20.656 156 20.512 c 155.984 20.359 155.969 20.188 155.945 20 c 155.93 19.812\n"
                                              " 155.918 19.617 155.902 19.422 c 155.895 19.227 155.891 19.051 155.891 18.898\n"
                                              " c 155.848 18.898 l 155.492 19.664 154.992 20.215 154.352 20.547 c 153.719\n"
                                              " 20.875 152.957 21.039 152.066 21.039 c 151.324 21.039 150.68 20.887 150.133\n"
                                              " 20.582 c 149.594 20.277 149.145 19.852 148.789 19.305 c 148.438 18.758 \n"
                                              "148.176 18.113 148.004 17.371 c 147.836 16.621 147.754 15.805 147.754 14.922\n"
                                              " c 147.754 14.027 147.84 13.203 148.016 12.453 c 148.199 11.703 148.473 \n"
                                              "11.059 148.848 10.52 c 149.219 9.973 149.688 9.547 150.258 9.242 c 150.832\n"
                                              " 8.938 151.516 8.785 152.301 8.785 c 152.688 8.785 153.059 8.824 153.414\n"
                                              " 8.906 c 153.77 8.988 154.102 9.109 154.41 9.277 c 154.715 9.445 154.992\n"
                                              " 9.66 155.242 9.922 c 155.488 10.184 155.699 10.5 155.875 10.871 c 155.898\n"
                                              " 10.871 l 155.898 10.797 155.895 10.691 155.887 10.555 c 155.887 10.41 155.887\n"
                                              " 10.246 155.887 10.062 c 155.887 9.879 155.883 9.691 155.875 9.496 c 155.875\n"
                                              " 9.301 155.875 9.109 155.875 8.93 c 155.875 4.613 l 158.945 4.613 l 158.945\n"
                                              " 18.25 l 158.945 18.824 158.957 19.34 158.977 19.789 c 159 20.234 159.016\n"
                                              " 20.578 159.031 20.828 c 156.059 20.828 l 155.918 14.852 m 155.918 14.07\n"
                                              " 155.844 13.426 155.699 12.918 c 155.555 12.402 155.359 11.992 155.121 11.695\n"
                                              " c 154.887 11.391 154.617 11.18 154.312 11.062 c 154.016 10.938 153.707 \n"
                                              "10.875 153.395 10.875 c 153 10.875 152.652 10.953 152.344 11.105 c 152.047\n"
                                              " 11.258 151.789 11.5 151.578 11.828 c 151.375 12.156 151.219 12.574 151.109\n"
                                              " 13.086 c 151.008 13.598 150.957 14.211 150.957 14.934 c 150.957 17.613 \n"
                                              "151.762 18.953 153.371 18.953 c 153.676 18.953 153.984 18.887 154.289 18.758\n"
                                              " c 154.594 18.625 154.867 18.406 155.109 18.09 c 155.352 17.777 155.543 \n"
                                              "17.359 155.688 16.832 c 155.84 16.301 155.918 15.641 155.918 14.855 c S Q\n"
                                              "Q q\n"
                                              "0.74902 0 0 rg /a1 gs\n"
                                              "1 1 1 RG 0.797243 w\n"
                                              "1 J\n"
                                              "1 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                              "24.715 1.77 26.086 3.398 26.086 c 167.109 26.086 l 168.738 26.086 170.109\n"
                                              " 24.715 170.109 23.086 c 170.109 3.398 l 170.109 1.77 168.738 0.398 167.109\n"
                                              " 0.398 c h\n"
                                              "3.867 3.844 m 166.664 3.844 l 166.664 22.617 l 3.867 22.617 l h\n"
                                              "3.867 3.844 m B Q\n"
                                              "Q\n";

static std::unique_ptr<Dict> getNotApprovedStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
