//========================================================================
//
// annot_stamp_for_public_release.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_FOR_PUBLIC_RELEASE_H
#define ANNOT_STAMP_FOR_PUBLIC_RELEASE_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_FOR_PUBLIC_RELEASE_WIDTH = 222.258179;
static const double ANNOT_STAMP_FOR_PUBLIC_RELEASE_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_FOR_PUBLIC_RELEASE = "1 0 0 -1 0 26.484741 cm\n"
                                                    "q\n"
                                                    "1 1 1 rg /a0 gs\n"
                                                    "3.406 2.129 m 218.867 2.129 l 219.566 2.129 220.137 2.828 220.137 3.398\n"
                                                    " c 220.137 23.09 l 220.137 23.789 219.57 24.359 218.867 24.359 c 3.406 24.359\n"
                                                    " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                                    " 2.129 3.406 2.129 c h\n"
                                                    "3.406 2.129 m f\n"
                                                    "0 0.298039 0.431373 rg /a1 gs\n"
                                                    "1 1 1 RG 0.265748 w\n"
                                                    "0 J\n"
                                                    "0 j\n"
                                                    "[] 0.0 d\n"
                                                    "4 M q 1 0 0 1 0 0 cm\n"
                                                    "18.043 7.926 m 18.043 12.691 l 25.922 12.691 l 25.922 15.184 l 18.043 15.18\n"
                                                    " l 18.043 20.828 l 14.82 20.828 l 14.82 5.434 l 26.172 5.434 l 26.172 7.926\n"
                                                    " l 18.043 7.926 l 39.797 14.906 m 39.797 15.809 39.668 16.637 39.414 17.387\n"
                                                    " c 39.168 18.137 38.793 18.785 38.289 19.332 c 37.785 19.871 37.16 20.293\n"
                                                    " 36.41 20.598 c 35.66 20.895 34.785 21.047 33.789 21.047 c 32.828 21.047\n"
                                                    " 31.98 20.898 31.242 20.598 c 30.508 20.301 29.887 19.879 29.383 19.34 c\n"
                                                    " 28.887 18.801 28.512 18.156 28.258 17.406 c 28.004 16.648 27.875 15.816\n"
                                                    " 27.875 14.902 c 27.875 14.02 27.996 13.207 28.234 12.465 c 28.48 11.715\n"
                                                    " 28.855 11.066 29.348 10.52 c 29.844 9.973 30.465 9.547 31.215 9.242 c 31.965\n"
                                                    " 8.938 32.844 8.785 33.848 8.785 c 34.91 8.785 35.816 8.938 36.57 9.242 \n"
                                                    "c 37.32 9.547 37.934 9.973 38.406 10.52 c 38.887 11.059 39.238 11.703 39.457\n"
                                                    " 12.453 c 39.684 13.195 39.797 14.012 39.797 14.902 c 36.586 14.902 m 36.586\n"
                                                    " 13.496 36.355 12.477 35.898 11.844 c 35.441 11.211 34.773 10.895 33.898\n"
                                                    " 10.895 c 32.996 10.895 32.305 11.215 31.824 11.855 c 31.344 12.496 31.102\n"
                                                    " 13.512 31.102 14.902 c 31.102 15.609 31.164 16.219 31.289 16.727 c 31.422\n"
                                                    " 17.238 31.602 17.656 31.836 17.984 c 32.07 18.312 32.348 18.555 32.676 \n"
                                                    "18.715 c 33.004 18.867 33.363 18.945 33.758 18.945 c 34.211 18.945 34.609\n"
                                                    " 18.867 34.961 18.715 c 35.316 18.555 35.617 18.312 35.855 17.984 c 36.098\n"
                                                    " 17.656 36.277 17.238 36.402 16.727 c 36.527 16.215 36.59 15.609 36.59 14.902\n"
                                                    " c 42.25 20.824 m 42.25 11.777 l 42.25 11.523 42.246 11.254 42.238 10.969\n"
                                                    " c 42.238 10.684 42.23 10.414 42.215 10.16 c 42.207 9.898 42.199 9.664 42.191\n"
                                                    " 9.461 c 42.184 9.25 42.172 9.098 42.16 9.004 c 45.09 9.004 l 45.105 9.09\n"
                                                    " 45.117 9.246 45.133 9.461 c 45.148 9.672 45.16 9.906 45.176 10.16 c 45.191\n"
                                                    " 10.414 45.203 10.672 45.207 10.926 c 45.223 11.172 45.23 11.375 45.23 11.527\n"
                                                    " c 45.273 11.527 l 45.426 11.098 45.578 10.715 45.73 10.379 c 45.883 10.035\n"
                                                    " 46.062 9.75 46.266 9.516 c 46.477 9.273 46.727 9.094 47.02 8.969 c 47.312\n"
                                                    " 8.836 47.672 8.773 48.102 8.773 c 48.285 8.773 48.461 8.793 48.637 8.828\n"
                                                    " c 48.82 8.855 48.957 8.895 49.051 8.938 c 49.051 11.504 l 48.855 11.461\n"
                                                    " 48.652 11.422 48.449 11.395 c 48.254 11.359 48.016 11.34 47.738 11.34 c\n"
                                                    " 46.973 11.34 46.375 11.648 45.945 12.27 c 45.523 12.891 45.312 13.805 45.312\n"
                                                    " 15.023 c 45.312 20.824 l 42.246 20.828 l 69.75 10.309 m 69.75 10.973 69.637\n"
                                                    " 11.613 69.41 12.23 c 69.191 12.844 68.852 13.387 68.395 13.859 c 67.938\n"
                                                    " 14.332 67.352 14.711 66.645 14.996 c 65.938 15.273 65.102 15.41 64.133 \n"
                                                    "15.41 c 60.309 15.41 l 60.309 20.828 l 57.086 20.828 l 57.086 5.434 l 64.004\n"
                                                    " 5.434 l 64.988 5.434 65.84 5.555 66.562 5.793 c 67.285 6.027 67.883 6.359\n"
                                                    " 68.355 6.789 c 68.828 7.219 69.18 7.734 69.406 8.328 c 69.641 8.926 69.758\n"
                                                    " 9.586 69.758 10.305 c 66.512 10.359 m 66.512 9.566 66.27 8.965 65.789 8.555\n"
                                                    " c 65.316 8.141 64.602 7.934 63.648 7.934 c 60.309 7.938 l 60.309 12.93 \n"
                                                    "l 63.73 12.93 l 64.211 12.93 64.621 12.867 64.965 12.742 c 65.316 12.617\n"
                                                    " 65.602 12.445 65.828 12.219 c 66.062 11.992 66.23 11.723 66.34 11.41 c \n"
                                                    "66.449 11.09 66.504 10.738 66.504 10.359 c 74.992 9.004 m 74.992 15.637 \n"
                                                    "l 74.992 16.094 75.027 16.52 75.102 16.902 c 75.176 17.281 75.293 17.609\n"
                                                    " 75.461 17.887 c 75.629 18.156 75.844 18.367 76.105 18.52 c 76.375 18.672\n"
                                                    " 76.703 18.75 77.09 18.75 c 77.461 18.75 77.797 18.668 78.094 18.508 c 78.398\n"
                                                    " 18.34 78.66 18.105 78.879 17.809 c 79.098 17.504 79.266 17.141 79.383 16.727\n"
                                                    " c 79.508 16.305 79.57 15.84 79.57 15.34 c 79.57 9.004 l 82.641 9.004 l \n"
                                                    "82.641 18.184 l 82.641 18.43 82.641 18.695 82.641 18.969 c 82.648 19.238\n"
                                                    " 82.656 19.496 82.664 19.746 c 82.68 19.988 82.691 20.203 82.695 20.402 \n"
                                                    "c 82.711 20.59 82.723 20.734 82.727 20.828 c 79.797 20.828 l 79.789 20.742\n"
                                                    " 79.773 20.602 79.754 20.414 c 79.738 20.219 79.727 20.004 79.711 19.77 \n"
                                                    "c 79.703 19.535 79.691 19.305 79.68 19.07 c 79.672 18.836 79.668 18.641 \n"
                                                    "79.668 18.48 c 79.613 18.48 l 79.207 19.375 78.684 20.027 78.051 20.438 \n"
                                                    "c 77.426 20.844 76.676 21.051 75.812 21.051 c 75.105 21.051 74.504 20.934\n"
                                                    " 74.008 20.699 c 73.512 20.465 73.109 20.148 72.797 19.75 c 72.492 19.344\n"
                                                    " 72.27 18.859 72.129 18.309 c 71.992 17.754 71.922 17.156 71.922 16.516 \n"
                                                    "c 71.922 9.008 l 74.992 9.008 l 96.965 14.875 m 96.965 15.77 96.875 16.598\n"
                                                    " 96.691 17.355 c 96.516 18.105 96.242 18.758 95.871 19.312 c 95.5 19.859\n"
                                                    " 95.027 20.285 94.449 20.59 c 93.883 20.895 93.207 21.047 92.43 21.047 c\n"
                                                    " 92.078 21.047 91.73 21.012 91.379 20.938 c 91.027 20.863 90.699 20.746 \n"
                                                    "90.383 20.578 c 90.07 20.41 89.781 20.191 89.52 19.922 c 89.258 19.652 89.031\n"
                                                    " 19.32 88.844 18.926 c 88.82 18.926 l 88.82 19.078 88.812 19.254 88.797 \n"
                                                    "19.449 c 88.789 19.645 88.777 19.84 88.766 20.027 c 88.75 20.211 88.734 \n"
                                                    "20.375 88.711 20.52 c 88.695 20.664 88.684 20.766 88.668 20.824 c 85.684\n"
                                                    " 20.824 l 85.707 20.57 85.723 20.207 85.738 19.742 c 85.762 19.27 85.77 \n"
                                                    "18.73 85.77 18.125 c 85.77 4.609 l 88.84 4.609 l 88.84 9.133 l 88.84 9.367\n"
                                                    " 88.836 9.594 88.828 9.82 c 88.828 10.039 88.824 10.242 88.816 10.434 c \n"
                                                    "88.809 10.652 88.801 10.859 88.793 11.055 c 88.836 11.055 l 89.207 10.238\n"
                                                    " 89.719 9.656 90.367 9.305 c 91.016 8.953 91.766 8.781 92.617 8.781 c 93.375\n"
                                                    " 8.781 94.027 8.934 94.574 9.238 c 95.121 9.535 95.57 9.961 95.918 10.504\n"
                                                    " c 96.273 11.043 96.539 11.684 96.703 12.426 c 96.871 13.168 96.953 13.98\n"
                                                    " 96.953 14.863 c 93.75 14.863 m 93.75 13.523 93.555 12.527 93.16 11.879 \n"
                                                    "c 92.766 11.23 92.16 10.906 91.336 10.906 c 91.023 10.906 90.715 10.969 \n"
                                                    "90.406 11.094 c 90.102 11.219 89.828 11.438 89.586 11.75 c 89.344 12.055\n"
                                                    " 89.152 12.473 89.008 12.996 c 88.863 13.512 88.789 14.168 88.789 14.965\n"
                                                    " c 88.789 15.738 88.863 16.379 89.008 16.887 c 89.152 17.398 89.344 17.805\n"
                                                    " 89.574 18.109 c 89.809 18.414 90.078 18.629 90.383 18.754 c 90.688 18.879\n"
                                                    " 91 18.941 91.312 18.941 c 92.094 18.941 92.691 18.621 93.117 17.98 c 93.539\n"
                                                    " 17.332 93.75 16.293 93.75 14.867 c 99.441 20.824 m 99.441 4.609 l 102.512\n"
                                                    " 4.609 l 102.512 20.824 l 99.441 20.824 l 105.648 6.871 m 105.648 4.609 \n"
                                                    "l 108.719 4.609 l 108.719 6.871 l 105.648 6.871 l 105.648 20.824 m 105.648\n"
                                                    " 9 l 108.719 9 l 108.719 20.824 l 105.648 20.824 l 116.781 21.043 m 115.84\n"
                                                    " 21.043 115.02 20.898 114.312 20.605 c 113.613 20.312 113.031 19.902 112.562\n"
                                                    " 19.371 c 112.098 18.84 111.746 18.203 111.512 17.457 c 111.277 16.707 111.16\n"
                                                    " 15.879 111.16 14.977 c 111.16 13.992 111.289 13.117 111.543 12.355 c 111.797\n"
                                                    " 11.582 112.164 10.934 112.648 10.41 c 113.129 9.879 113.719 9.473 114.418\n"
                                                    " 9.199 c 115.125 8.922 115.926 8.785 116.82 8.785 c 117.586 8.785 118.262\n"
                                                    " 8.887 118.852 9.09 c 119.449 9.293 119.961 9.574 120.391 9.93 c 120.82 \n"
                                                    "10.281 121.168 10.695 121.43 11.176 c 121.699 11.656 121.887 12.172 121.988\n"
                                                    " 12.727 c 118.895 12.879 l 118.809 12.273 118.59 11.793 118.238 11.438 c\n"
                                                    " 117.887 11.074 117.395 10.891 116.754 10.891 c 115.93 10.891 115.328 11.23\n"
                                                    " 114.949 11.906 c 114.57 12.582 114.383 13.566 114.383 14.855 c 114.383 \n"
                                                    "17.578 115.188 18.941 116.797 18.941 c 117.379 18.941 117.867 18.758 118.262\n"
                                                    " 18.395 c 118.656 18.023 118.898 17.473 118.992 16.746 c 122.074 16.887 \n"
                                                    "l 122 17.434 121.832 17.957 121.57 18.461 c 121.316 18.957 120.965 19.398\n"
                                                    " 120.52 19.781 c 120.082 20.16 119.551 20.465 118.926 20.699 c 118.301 20.926\n"
                                                    " 117.582 21.039 116.773 21.039 c 141.02 20.82 m 137.445 14.973 l 133.664\n"
                                                    " 14.973 l 133.664 20.82 l 130.441 20.82 l 130.469 5.434 l 138.16 5.434 l\n"
                                                    " 139.121 5.434 139.961 5.543 140.672 5.762 c 141.395 5.973 141.992 6.277\n"
                                                    " 142.477 6.68 c 142.957 7.074 143.312 7.555 143.547 8.121 c 143.789 8.684\n"
                                                    " 143.906 9.316 143.906 10.023 c 143.906 10.598 143.82 11.129 143.645 11.609\n"
                                                    " c 143.477 12.082 143.238 12.504 142.934 12.875 c 142.637 13.246 142.277\n"
                                                    " 13.559 141.863 13.816 c 141.449 14.062 140.996 14.246 140.508 14.363 c \n"
                                                    "144.672 20.832 l 141.043 20.832 l 140.66 10.156 m 140.66 9.406 140.414 8.848\n"
                                                    " 139.918 8.484 c 139.43 8.121 138.73 7.938 137.82 7.938 c 133.691 7.938 \n"
                                                    "l 133.691 12.484 l 137.91 12.484 l 138.391 12.484 138.801 12.43 139.145 \n"
                                                    "12.32 c 139.496 12.203 139.777 12.043 139.996 11.84 c 140.223 11.629 140.391\n"
                                                    " 11.383 140.5 11.098 c 140.609 10.812 140.664 10.5 140.664 10.156 c 151.547\n"
                                                    " 21.051 m 150.695 21.051 149.926 20.926 149.242 20.68 c 148.566 20.426 147.984\n"
                                                    " 20.043 147.504 19.531 c 147.023 19.016 146.656 18.371 146.398 17.598 c \n"
                                                    "146.145 16.816 146.016 15.906 146.016 14.867 c 146.016 13.738 146.164 12.789\n"
                                                    " 146.465 12.016 c 146.77 11.242 147.18 10.621 147.688 10.148 c 148.203 9.668\n"
                                                    " 148.797 9.32 149.469 9.109 c 150.141 8.898 150.844 8.793 151.59 8.793 c\n"
                                                    " 152.523 8.793 153.316 8.957 153.973 9.285 c 154.637 9.605 155.18 10.059\n"
                                                    " 155.602 10.641 c 156.023 11.223 156.332 11.922 156.531 12.738 c 156.727\n"
                                                    " 13.547 156.828 14.441 156.828 15.426 c 156.828 15.512 l 149.246 15.512 \n"
                                                    "l 149.246 16.008 149.289 16.469 149.379 16.898 c 149.465 17.32 149.609 17.688\n"
                                                    " 149.805 18.004 c 150 18.309 150.258 18.555 150.57 18.734 c 150.883 18.91\n"
                                                    " 151.262 18.996 151.707 18.996 c 152.246 18.996 152.688 18.883 153.027 18.656\n"
                                                    " c 153.371 18.422 153.613 18.066 153.758 17.586 c 156.652 17.836 l 156.52\n"
                                                    " 18.172 156.336 18.527 156.094 18.906 c 155.859 19.285 155.547 19.633 155.152\n"
                                                    " 19.957 c 154.758 20.27 154.266 20.531 153.676 20.742 c 153.094 20.945 152.383\n"
                                                    " 21.047 151.547 21.047 c 151.547 10.723 m 151.234 10.723 150.938 10.777 \n"
                                                    "150.66 10.887 c 150.391 10.988 150.152 11.156 149.949 11.391 c 149.754 11.617\n"
                                                    " 149.594 11.91 149.469 12.277 c 149.344 12.641 149.277 13.078 149.262 13.59\n"
                                                    " c 153.852 13.59 l 153.793 12.637 153.562 11.922 153.164 11.449 c 152.762\n"
                                                    " 10.969 152.223 10.727 151.547 10.727 c 159.164 20.832 m 159.164 4.617 l\n"
                                                    " 162.234 4.617 l 162.234 20.832 l 159.164 20.832 l 170.211 21.051 m 169.359\n"
                                                    " 21.051 168.59 20.926 167.906 20.68 c 167.23 20.426 166.648 20.043 166.168\n"
                                                    " 19.531 c 165.688 19.016 165.32 18.371 165.062 17.598 c 164.809 16.816 164.68\n"
                                                    " 15.906 164.68 14.867 c 164.68 13.738 164.828 12.789 165.129 12.016 c 165.434\n"
                                                    " 11.242 165.844 10.621 166.352 10.148 c 166.867 9.668 167.461 9.32 168.133\n"
                                                    " 9.109 c 168.805 8.898 169.508 8.793 170.254 8.793 c 171.188 8.793 171.98\n"
                                                    " 8.957 172.637 9.285 c 173.301 9.605 173.844 10.059 174.266 10.641 c 174.688\n"
                                                    " 11.223 174.996 11.922 175.195 12.738 c 175.391 13.547 175.492 14.441 175.492\n"
                                                    " 15.426 c 175.492 15.512 l 167.91 15.512 l 167.91 16.008 167.953 16.469 \n"
                                                    "168.043 16.898 c 168.129 17.32 168.273 17.688 168.469 18.004 c 168.664 18.309\n"
                                                    " 168.922 18.555 169.234 18.734 c 169.547 18.91 169.926 18.996 170.371 18.996\n"
                                                    " c 170.91 18.996 171.352 18.883 171.691 18.656 c 172.035 18.422 172.277 \n"
                                                    "18.066 172.422 17.586 c 175.316 17.836 l 175.184 18.172 175 18.527 174.758\n"
                                                    " 18.906 c 174.523 19.285 174.211 19.633 173.816 19.957 c 173.422 20.27 172.93\n"
                                                    " 20.531 172.34 20.742 c 171.758 20.945 171.047 21.047 170.211 21.047 c 170.211\n"
                                                    " 10.723 m 169.898 10.723 169.602 10.777 169.324 10.887 c 169.055 10.988 \n"
                                                    "168.816 11.156 168.613 11.391 c 168.418 11.617 168.258 11.91 168.133 12.277\n"
                                                    " c 168.008 12.641 167.941 13.078 167.926 13.59 c 172.516 13.59 l 172.457\n"
                                                    " 12.637 172.227 11.922 171.828 11.449 c 171.426 10.969 170.887 10.727 170.211\n"
                                                    " 10.727 c 180.559 21.051 m 179.992 21.051 179.48 20.973 179.027 20.82 c \n"
                                                    "178.582 20.66 178.203 20.43 177.891 20.133 c 177.578 19.828 177.336 19.453\n"
                                                    " 177.168 19.008 c 177 18.562 176.918 18.059 176.918 17.488 c 176.918 16.789\n"
                                                    " 177.039 16.203 177.277 15.73 c 177.523 15.25 177.859 14.863 178.281 14.57\n"
                                                    " c 178.703 14.273 179.199 14.059 179.766 13.926 c 180.332 13.789 180.938\n"
                                                    " 13.715 181.578 13.707 c 184.125 13.664 l 184.125 13.062 l 184.125 12.633\n"
                                                    " 184.086 12.277 184.004 11.992 c 183.93 11.699 183.82 11.465 183.676 11.281\n"
                                                    " c 183.531 11.098 183.348 10.973 183.129 10.898 c 182.918 10.816 182.672\n"
                                                    " 10.777 182.398 10.777 c 182.145 10.777 181.914 10.805 181.711 10.855 c \n"
                                                    "181.516 10.906 181.344 10.996 181.199 11.129 c 181.055 11.254 180.934 11.426\n"
                                                    " 180.84 11.641 c 180.754 11.852 180.691 12.121 180.652 12.449 c 177.449 \n"
                                                    "12.297 l 177.535 11.781 177.695 11.309 177.93 10.887 c 178.164 10.457 178.484\n"
                                                    " 10.086 178.891 9.773 c 179.305 9.461 179.812 9.219 180.41 9.051 c 181.016\n"
                                                    " 8.875 181.723 8.789 182.531 8.789 c 183.266 8.789 183.922 8.879 184.5 9.062\n"
                                                    " c 185.074 9.246 185.562 9.52 185.965 9.883 c 186.367 10.238 186.672 10.68\n"
                                                    " 186.883 11.203 c 187.094 11.727 187.199 12.336 187.199 13.027 c 187.199\n"
                                                    " 17.332 l 187.199 17.609 187.211 17.855 187.23 18.074 c 187.258 18.293 187.309\n"
                                                    " 18.477 187.371 18.633 c 187.445 18.777 187.543 18.891 187.668 18.973 c \n"
                                                    "187.801 19.047 187.965 19.082 188.172 19.082 c 188.406 19.082 188.629 19.059\n"
                                                    " 188.848 19.016 c 188.848 20.676 l 188.664 20.719 188.5 20.758 188.355 20.797\n"
                                                    " c 188.211 20.832 188.062 20.863 187.918 20.883 c 187.773 20.906 187.617\n"
                                                    " 20.922 187.449 20.938 c 187.289 20.953 187.098 20.961 186.883 20.961 c \n"
                                                    "186.109 20.961 185.539 20.773 185.168 20.395 c 184.805 20.016 184.586 19.457\n"
                                                    " 184.512 18.723 c 184.445 18.723 l 184.039 19.457 183.512 20.031 182.871\n"
                                                    " 20.438 c 182.238 20.844 181.465 21.051 180.555 21.051 c 184.129 15.359 \n"
                                                    "m 182.555 15.383 l 182.227 15.398 181.914 15.426 181.613 15.469 c 181.32\n"
                                                    " 15.504 181.062 15.59 180.836 15.719 c 180.617 15.844 180.441 16.023 180.312\n"
                                                    " 16.266 c 180.18 16.508 180.117 16.832 180.117 17.25 c 180.117 17.812 180.246\n"
                                                    " 18.23 180.5 18.508 c 180.762 18.777 181.109 18.91 181.539 18.91 c 181.934\n"
                                                    " 18.91 182.289 18.828 182.609 18.66 c 182.93 18.492 183.199 18.273 183.418\n"
                                                    " 18.004 c 183.645 17.727 183.82 17.41 183.941 17.055 c 184.066 16.699 184.129\n"
                                                    " 16.332 184.129 15.961 c 184.129 15.359 l 200.246 17.379 m 200.246 17.945\n"
                                                    " 200.125 18.457 199.887 18.91 c 199.652 19.363 199.312 19.746 198.859 20.07\n"
                                                    " c 198.406 20.383 197.855 20.629 197.199 20.801 c 196.543 20.969 195.797\n"
                                                    " 21.051 194.961 21.051 c 194.211 21.051 193.531 20.996 192.93 20.887 c 192.324\n"
                                                    " 20.777 191.793 20.598 191.336 20.352 c 190.883 20.098 190.504 19.77 190.199\n"
                                                    " 19.367 c 189.895 18.965 189.664 18.473 189.512 17.883 c 192.211 17.48 l\n"
                                                    " 192.297 17.809 192.418 18.074 192.57 18.277 c 192.723 18.48 192.914 18.637\n"
                                                    " 193.137 18.746 c 193.363 18.855 193.625 18.93 193.922 18.965 c 194.227 \n"
                                                    "19 194.574 19.02 194.961 19.02 c 195.312 19.02 195.633 19 195.934 18.965\n"
                                                    " c 196.238 18.922 196.5 18.852 196.719 18.758 c 196.945 18.656 197.121 18.516\n"
                                                    " 197.242 18.344 c 197.367 18.16 197.43 17.938 197.43 17.668 c 197.43 17.363\n"
                                                    " 197.34 17.121 197.156 16.945 c 196.98 16.762 196.738 16.617 196.426 16.508\n"
                                                    " c 196.121 16.391 195.754 16.293 195.332 16.211 c 194.918 16.125 194.473\n"
                                                    " 16.023 194 15.914 c 193.504 15.805 193.016 15.672 192.535 15.52 c 192.055\n"
                                                    " 15.367 191.625 15.16 191.246 14.898 c 190.867 14.637 190.562 14.305 190.328\n"
                                                    " 13.902 c 190.094 13.496 189.977 12.98 189.977 12.363 c 189.977 11.801 190.086\n"
                                                    " 11.305 190.305 10.867 c 190.523 10.422 190.844 10.047 191.266 9.742 c 191.688\n"
                                                    " 9.43 192.207 9.191 192.828 9.031 c 193.453 8.863 194.172 8.781 194.98 8.781\n"
                                                    " c 195.621 8.781 196.219 8.844 196.773 8.969 c 197.328 9.086 197.824 9.273\n"
                                                    " 198.258 9.535 c 198.695 9.789 199.059 10.117 199.352 10.52 c 199.648 10.922\n"
                                                    " 199.859 11.406 199.973 11.973 c 197.25 12.258 l 197.199 11.973 197.109 \n"
                                                    "11.742 196.977 11.559 c 196.844 11.371 196.68 11.219 196.484 11.109 c 196.297\n"
                                                    " 11 196.074 10.926 195.816 10.891 c 195.562 10.848 195.281 10.824 194.977\n"
                                                    " 10.824 c 194.25 10.824 193.703 10.918 193.336 11.109 c 192.973 11.293 192.789\n"
                                                    " 11.602 192.789 12.039 c 192.789 12.309 192.863 12.523 193.008 12.684 c \n"
                                                    "193.16 12.844 193.371 12.98 193.641 13.086 c 193.918 13.188 194.242 13.277\n"
                                                    " 194.613 13.359 c 194.992 13.434 195.402 13.523 195.848 13.633 c 196.395\n"
                                                    " 13.75 196.93 13.887 197.453 14.047 c 197.984 14.199 198.453 14.414 198.863\n"
                                                    " 14.691 c 199.277 14.961 199.609 15.312 199.859 15.742 c 200.113 16.172 \n"
                                                    "200.242 16.719 200.242 17.383 c 207.574 21.055 m 206.723 21.055 205.953 \n"
                                                    "20.93 205.27 20.684 c 204.594 20.43 204.012 20.047 203.531 19.535 c 203.051\n"
                                                    " 19.02 202.684 18.375 202.426 17.602 c 202.172 16.82 202.043 15.91 202.043\n"
                                                    " 14.871 c 202.043 13.742 202.191 12.793 202.492 12.02 c 202.797 11.246 203.207\n"
                                                    " 10.625 203.715 10.152 c 204.23 9.672 204.824 9.324 205.496 9.113 c 206.168\n"
                                                    " 8.902 206.871 8.797 207.617 8.797 c 208.551 8.797 209.344 8.961 210 9.289\n"
                                                    " c 210.664 9.609 211.207 10.062 211.629 10.645 c 212.051 11.227 212.359 \n"
                                                    "11.926 212.559 12.742 c 212.754 13.551 212.855 14.445 212.855 15.43 c 212.855\n"
                                                    " 15.516 l 205.273 15.516 l 205.273 16.012 205.316 16.473 205.406 16.902 \n"
                                                    "c 205.492 17.324 205.637 17.691 205.832 18.008 c 206.027 18.312 206.285 \n"
                                                    "18.559 206.598 18.738 c 206.91 18.914 207.289 19 207.734 19 c 208.273 19\n"
                                                    " 208.715 18.887 209.055 18.66 c 209.398 18.426 209.641 18.07 209.785 17.59\n"
                                                    " c 212.68 17.84 l 212.547 18.176 212.363 18.531 212.121 18.91 c 211.887 \n"
                                                    "19.289 211.574 19.637 211.18 19.961 c 210.785 20.273 210.293 20.535 209.703\n"
                                                    " 20.746 c 209.121 20.949 208.41 21.051 207.574 21.051 c 207.574 10.727 m\n"
                                                    " 207.262 10.727 206.965 10.781 206.688 10.891 c 206.418 10.992 206.18 11.16\n"
                                                    " 205.977 11.395 c 205.781 11.621 205.621 11.914 205.496 12.281 c 205.371\n"
                                                    " 12.645 205.305 13.082 205.289 13.594 c 209.879 13.594 l 209.82 12.641 209.59\n"
                                                    " 11.926 209.191 11.453 c 208.789 10.973 208.25 10.73 207.574 10.73 c B Q\n"
                                                    "Q q\n"
                                                    "0 0 222 26.484 re W n\n"
                                                    "0 0.298039 0.431373 rg /a1 gs\n"
                                                    "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                                    "24.715 1.77 26.086 3.398 26.086 c 218.859 26.086 l 220.488 26.086 221.859\n"
                                                    " 24.715 221.859 23.086 c 221.859 3.398 l 221.859 1.77 220.488 0.398 218.859\n"
                                                    " 0.398 c h\n"
                                                    "3.867 3.844 m 218.414 3.844 l 218.414 22.617 l 3.867 22.617 l h\n"
                                                    "3.867 3.844 m f\n"
                                                    "Q q\n"
                                                    "1 1 1 RG /a1 gs\n"
                                                    "0.797243 w\n"
                                                    "1 J\n"
                                                    "1 j\n"
                                                    "[] 0.0 d\n"
                                                    "4 M q 1 0 0 1 0 0 cm\n"
                                                    "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                                    "24.715 1.77 26.086 3.398 26.086 c 218.859 26.086 l 220.488 26.086 221.859\n"
                                                    " 24.715 221.859 23.086 c 221.859 3.398 l 221.859 1.77 220.488 0.398 218.859\n"
                                                    " 0.398 c h\n"
                                                    "3.867 3.844 m 218.414 3.844 l 218.414 22.617 l 3.867 22.617 l h\n"
                                                    "3.867 3.844 m S Q\n"
                                                    "Q\n";

static std::unique_ptr<Dict> getForPublicReleaseStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
