//========================================================================
//
// annot_stamp_expired.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_EXPIRED_H
#define ANNOT_STAMP_EXPIRED_H

#include "PDFDoc.h"
#include "Dict.h"
#include "Object.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_EXPIRED_WIDTH = 106.758179;
static const double ANNOT_STAMP_EXPIRED_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_EXPIRED = "1 0 0 -1 0 26.484741 cm\n"
                                         "q\n"
                                         "1 1 1 rg /a0 gs\n"
                                         "3.406 2.129 m 103.367 2.129 l 104.07 2.129 104.637 2.695 104.637 3.398 \n"
                                         "c 104.637 23.09 l 104.637 23.793 104.07 24.359 103.367 24.359 c 3.406 24.355\n"
                                         " l 2.703 24.355 2.137 23.789 2.137 23.086 c 2.137 3.395 l 2.137 2.691 2.703\n"
                                         " 2.125 3.406 2.125 c h\n"
                                         "3.406 2.129 m f\n"
                                         "Q q\n"
                                         "0.74902 0 0 RG /a1 gs\n"
                                         "3.454725 w\n"
                                         "1 J\n"
                                         "1 j\n"
                                         "[] 0.0 d\n"
                                         "4 M q 1 0 0 1 0 0 cm\n"
                                         "3.406 2.129 m 103.367 2.129 l 104.07 2.129 104.637 2.695 104.637 3.398 \n"
                                         "c 104.637 23.09 l 104.637 23.793 104.07 24.359 103.367 24.359 c 3.406 24.355\n"
                                         " l 2.703 24.355 2.137 23.789 2.137 23.086 c 2.137 3.395 l 2.137 2.691 2.703\n"
                                         " 2.125 3.406 2.125 c h\n"
                                         "3.406 2.129 m S Q\n"
                                         "0.74902 0 0 rg 14.82 20.828 m 14.82 5.434 l 26.926 5.434 l 26.926 7.926 l 18.043 7.926\n"
                                         " l 18.043 11.793 l 26.262 11.793 l 26.262 14.285 l 18.043 14.285 l 18.043\n"
                                         " 18.34 l 27.375 18.34 l 27.375 20.832 l 14.82 20.828 l 37.219 20.828 m 34.465\n"
                                         " 16.543 l 31.688 20.828 l 28.422 20.828 l 32.75 14.719 l 28.629 9.004 l \n"
                                         "31.941 9.004 l 34.465 12.871 l 36.977 9.004 l 40.309 9.004 l 36.188 14.688\n"
                                         " l 40.547 20.828 l 37.215 20.828 l 53.473 14.863 m 53.473 15.758 53.383 \n"
                                         "16.586 53.199 17.344 c 53.023 18.102 52.75 18.754 52.379 19.301 c 52.008\n"
                                         " 19.848 51.535 20.277 50.957 20.59 c 50.391 20.895 49.715 21.047 48.938 \n"
                                         "21.047 c 48.586 21.047 48.238 21.012 47.887 20.938 c 47.543 20.863 47.215\n"
                                         " 20.75 46.902 20.586 c 46.59 20.418 46.297 20.203 46.027 19.941 c 45.766\n"
                                         " 19.672 45.539 19.34 45.352 18.945 c 45.285 18.945 l 45.293 18.98 45.301\n"
                                         " 19.074 45.309 19.219 c 45.316 19.363 45.324 19.535 45.332 19.73 c 45.34\n"
                                         " 19.918 45.344 20.125 45.344 20.344 c 45.352 20.555 45.355 20.75 45.355 \n"
                                         "20.934 c 45.355 25.469 l 42.285 25.469 l 42.285 11.723 l 42.285 11.117 42.273\n"
                                         " 10.578 42.254 10.105 c 42.238 9.633 42.223 9.266 42.199 9 c 45.184 9 l \n"
                                         "45.199 9.051 45.211 9.148 45.227 9.297 c 45.25 9.441 45.262 9.609 45.27 \n"
                                         "9.801 c 45.285 9.988 45.297 10.188 45.301 10.391 c 45.309 10.594 45.312 \n"
                                         "10.773 45.312 10.926 c 45.355 10.926 l 45.727 10.145 46.238 9.59 46.887 \n"
                                         "9.254 c 47.535 8.918 48.285 8.75 49.137 8.75 c 49.887 8.75 50.535 8.902 \n"
                                         "51.082 9.207 c 51.629 9.512 52.078 9.934 52.426 10.473 c 52.781 11.012 53.047\n"
                                         " 11.656 53.211 12.406 c 53.387 13.148 53.473 13.965 53.473 14.855 c 50.27\n"
                                         " 14.855 m 50.27 13.508 50.066 12.512 49.656 11.863 c 49.25 11.207 48.641\n"
                                         " 10.879 47.832 10.879 c 47.527 10.879 47.219 10.945 46.914 11.074 c 46.617\n"
                                         " 11.199 46.348 11.418 46.105 11.73 c 45.871 12.035 45.68 12.453 45.527 12.977\n"
                                         " c 45.383 13.492 45.309 14.148 45.309 14.945 c 45.309 15.719 45.383 16.363\n"
                                         " 45.527 16.879 c 45.672 17.391 45.863 17.797 46.094 18.102 c 46.336 18.406\n"
                                         " 46.605 18.625 46.902 18.758 c 47.199 18.883 47.504 18.945 47.809 18.945\n"
                                         " c 48.203 18.945 48.551 18.867 48.859 18.715 c 49.164 18.555 49.422 18.312\n"
                                         " 49.625 17.984 c 49.836 17.648 49.996 17.223 50.105 16.707 c 50.215 16.191\n"
                                         " 50.27 15.574 50.27 14.859 c 55.969 6.875 m 55.969 4.613 l 59.039 4.613 \n"
                                         "l 59.039 6.875 l 55.969 6.875 l 55.969 20.828 m 55.969 9.004 l 59.039 9.004\n"
                                         " l 59.039 20.828 l 55.969 20.828 l 62.176 20.828 m 62.176 11.781 l 62.176\n"
                                         " 11.527 62.172 11.258 62.164 10.973 c 62.164 10.688 62.156 10.418 62.141\n"
                                         " 10.164 c 62.133 9.902 62.125 9.668 62.117 9.465 c 62.109 9.254 62.098 9.102\n"
                                         " 62.086 9.008 c 65.016 9.008 l 65.031 9.094 65.043 9.25 65.059 9.465 c 65.074\n"
                                         " 9.676 65.086 9.91 65.102 10.164 c 65.117 10.418 65.129 10.676 65.133 10.93\n"
                                         " c 65.148 11.176 65.156 11.379 65.156 11.531 c 65.199 11.531 l 65.352 11.102\n"
                                         " 65.504 10.719 65.656 10.383 c 65.809 10.039 65.988 9.754 66.191 9.52 c \n"
                                         "66.402 9.277 66.652 9.098 66.945 8.973 c 67.238 8.84 67.598 8.777 68.027\n"
                                         " 8.777 c 68.211 8.777 68.387 8.797 68.562 8.832 c 68.746 8.859 68.883 8.898\n"
                                         " 68.977 8.941 c 68.977 11.508 l 68.781 11.465 68.578 11.426 68.375 11.398\n"
                                         " c 68.18 11.363 67.941 11.344 67.664 11.344 c 66.898 11.344 66.301 11.652\n"
                                         " 65.871 12.273 c 65.449 12.895 65.238 13.809 65.238 15.027 c 65.238 20.828\n"
                                         " l 62.168 20.828 l 75.707 21.047 m 74.855 21.047 74.086 20.922 73.402 20.676\n"
                                         " c 72.727 20.422 72.145 20.039 71.664 19.527 c 71.184 19.012 70.816 18.367\n"
                                         " 70.559 17.594 c 70.305 16.812 70.176 15.902 70.176 14.863 c 70.176 13.734\n"
                                         " 70.324 12.785 70.625 12.012 c 70.93 11.238 71.34 10.617 71.848 10.145 c\n"
                                         " 72.363 9.664 72.957 9.316 73.629 9.105 c 74.301 8.895 75.004 8.789 75.75\n"
                                         " 8.789 c 76.684 8.789 77.477 8.953 78.133 9.281 c 78.797 9.602 79.34 10.055\n"
                                         " 79.762 10.637 c 80.184 11.219 80.492 11.918 80.691 12.734 c 80.887 13.543\n"
                                         " 80.988 14.438 80.988 15.422 c 80.988 15.508 l 73.41 15.508 l 73.41 16.004\n"
                                         " 73.453 16.465 73.543 16.895 c 73.629 17.316 73.773 17.684 73.969 18 c 74.164\n"
                                         " 18.305 74.422 18.551 74.734 18.73 c 75.047 18.906 75.426 18.992 75.871 \n"
                                         "18.992 c 76.41 18.992 76.852 18.879 77.191 18.652 c 77.535 18.418 77.777\n"
                                         " 18.062 77.922 17.582 c 80.816 17.832 l 80.684 18.168 80.5 18.523 80.258\n"
                                         " 18.902 c 80.023 19.281 79.711 19.629 79.316 19.953 c 78.922 20.266 78.43\n"
                                         " 20.527 77.84 20.738 c 77.258 20.941 76.547 21.043 75.711 21.043 c 75.711\n"
                                         " 10.719 m 75.398 10.719 75.102 10.773 74.824 10.883 c 74.555 10.984 74.316\n"
                                         " 11.152 74.113 11.387 c 73.918 11.613 73.758 11.906 73.633 12.273 c 73.508\n"
                                         " 12.637 73.441 13.074 73.426 13.586 c 78.016 13.586 l 77.957 12.633 77.727\n"
                                         " 11.918 77.328 11.445 c 76.926 10.965 76.387 10.723 75.711 10.723 c 90.988\n"
                                         " 20.828 m 90.973 20.77 90.957 20.668 90.934 20.523 c 90.918 20.371 90.902\n"
                                         " 20.199 90.879 20.012 c 90.863 19.824 90.852 19.629 90.836 19.434 c 90.828\n"
                                         " 19.238 90.824 19.062 90.824 18.91 c 90.781 18.91 l 90.426 19.676 89.926\n"
                                         " 20.227 89.285 20.559 c 88.652 20.887 87.891 21.051 87 21.051 c 86.258 21.051\n"
                                         " 85.613 20.898 85.066 20.594 c 84.527 20.289 84.078 19.863 83.723 19.316\n"
                                         " c 83.371 18.77 83.109 18.125 82.938 17.383 c 82.77 16.633 82.688 15.816\n"
                                         " 82.688 14.934 c 82.688 14.039 82.773 13.215 82.949 12.465 c 83.133 11.715\n"
                                         " 83.406 11.07 83.781 10.531 c 84.152 9.984 84.621 9.559 85.191 9.254 c 85.766\n"
                                         " 8.949 86.449 8.797 87.234 8.797 c 87.621 8.797 87.992 8.836 88.348 8.918\n"
                                         " c 88.703 9 89.035 9.121 89.344 9.289 c 89.648 9.457 89.926 9.672 90.176\n"
                                         " 9.934 c 90.422 10.195 90.633 10.512 90.809 10.883 c 90.832 10.883 l 90.832\n"
                                         " 10.809 90.828 10.703 90.82 10.566 c 90.82 10.422 90.82 10.258 90.82 10.074\n"
                                         " c 90.82 9.891 90.816 9.703 90.809 9.508 c 90.809 9.312 90.809 9.121 90.809\n"
                                         " 8.941 c 90.809 4.625 l 93.879 4.625 l 93.879 18.262 l 93.879 18.836 93.891\n"
                                         " 19.352 93.91 19.801 c 93.934 20.246 93.949 20.59 93.965 20.84 c 90.992 \n"
                                         "20.84 l 90.852 14.863 m 90.852 14.082 90.777 13.438 90.633 12.93 c 90.488\n"
                                         " 12.414 90.293 12.004 90.055 11.707 c 89.82 11.402 89.551 11.191 89.246 \n"
                                         "11.074 c 88.949 10.949 88.641 10.887 88.328 10.887 c 87.934 10.887 87.586\n"
                                         " 10.965 87.277 11.117 c 86.98 11.27 86.723 11.512 86.512 11.84 c 86.309 \n"
                                         "12.168 86.152 12.586 86.043 13.098 c 85.941 13.609 85.891 14.223 85.891 \n"
                                         "14.945 c 85.891 17.625 86.695 18.965 88.305 18.965 c 88.609 18.965 88.918\n"
                                         " 18.898 89.223 18.77 c 89.527 18.637 89.801 18.418 90.043 18.102 c 90.285\n"
                                         " 17.789 90.477 17.371 90.621 16.844 c 90.773 16.312 90.852 15.652 90.852\n"
                                         " 14.867 c f\n"
                                         "1 1 1 RG 0.531496 w\n"
                                         "0 J\n"
                                         "0 j\n"
                                         "q 1 0 0 1 0 0 cm\n"
                                         "14.82 20.828 m 14.82 5.434 l 26.926 5.434 l 26.926 7.926 l 18.043 7.926\n"
                                         " l 18.043 11.793 l 26.262 11.793 l 26.262 14.285 l 18.043 14.285 l 18.043\n"
                                         " 18.34 l 27.375 18.34 l 27.375 20.832 l 14.82 20.828 l 37.219 20.828 m 34.465\n"
                                         " 16.543 l 31.688 20.828 l 28.422 20.828 l 32.75 14.719 l 28.629 9.004 l \n"
                                         "31.941 9.004 l 34.465 12.871 l 36.977 9.004 l 40.309 9.004 l 36.188 14.688\n"
                                         " l 40.547 20.828 l 37.215 20.828 l 53.473 14.863 m 53.473 15.758 53.383 \n"
                                         "16.586 53.199 17.344 c 53.023 18.102 52.75 18.754 52.379 19.301 c 52.008\n"
                                         " 19.848 51.535 20.277 50.957 20.59 c 50.391 20.895 49.715 21.047 48.938 \n"
                                         "21.047 c 48.586 21.047 48.238 21.012 47.887 20.938 c 47.543 20.863 47.215\n"
                                         " 20.75 46.902 20.586 c 46.59 20.418 46.297 20.203 46.027 19.941 c 45.766\n"
                                         " 19.672 45.539 19.34 45.352 18.945 c 45.285 18.945 l 45.293 18.98 45.301\n"
                                         " 19.074 45.309 19.219 c 45.316 19.363 45.324 19.535 45.332 19.73 c 45.34\n"
                                         " 19.918 45.344 20.125 45.344 20.344 c 45.352 20.555 45.355 20.75 45.355 \n"
                                         "20.934 c 45.355 25.469 l 42.285 25.469 l 42.285 11.723 l 42.285 11.117 42.273\n"
                                         " 10.578 42.254 10.105 c 42.238 9.633 42.223 9.266 42.199 9 c 45.184 9 l \n"
                                         "45.199 9.051 45.211 9.148 45.227 9.297 c 45.25 9.441 45.262 9.609 45.27 \n"
                                         "9.801 c 45.285 9.988 45.297 10.188 45.301 10.391 c 45.309 10.594 45.312 \n"
                                         "10.773 45.312 10.926 c 45.355 10.926 l 45.727 10.145 46.238 9.59 46.887 \n"
                                         "9.254 c 47.535 8.918 48.285 8.75 49.137 8.75 c 49.887 8.75 50.535 8.902 \n"
                                         "51.082 9.207 c 51.629 9.512 52.078 9.934 52.426 10.473 c 52.781 11.012 53.047\n"
                                         " 11.656 53.211 12.406 c 53.387 13.148 53.473 13.965 53.473 14.855 c 50.27\n"
                                         " 14.855 m 50.27 13.508 50.066 12.512 49.656 11.863 c 49.25 11.207 48.641\n"
                                         " 10.879 47.832 10.879 c 47.527 10.879 47.219 10.945 46.914 11.074 c 46.617\n"
                                         " 11.199 46.348 11.418 46.105 11.73 c 45.871 12.035 45.68 12.453 45.527 12.977\n"
                                         " c 45.383 13.492 45.309 14.148 45.309 14.945 c 45.309 15.719 45.383 16.363\n"
                                         " 45.527 16.879 c 45.672 17.391 45.863 17.797 46.094 18.102 c 46.336 18.406\n"
                                         " 46.605 18.625 46.902 18.758 c 47.199 18.883 47.504 18.945 47.809 18.945\n"
                                         " c 48.203 18.945 48.551 18.867 48.859 18.715 c 49.164 18.555 49.422 18.312\n"
                                         " 49.625 17.984 c 49.836 17.648 49.996 17.223 50.105 16.707 c 50.215 16.191\n"
                                         " 50.27 15.574 50.27 14.859 c 55.969 6.875 m 55.969 4.613 l 59.039 4.613 \n"
                                         "l 59.039 6.875 l 55.969 6.875 l 55.969 20.828 m 55.969 9.004 l 59.039 9.004\n"
                                         " l 59.039 20.828 l 55.969 20.828 l 62.176 20.828 m 62.176 11.781 l 62.176\n"
                                         " 11.527 62.172 11.258 62.164 10.973 c 62.164 10.688 62.156 10.418 62.141\n"
                                         " 10.164 c 62.133 9.902 62.125 9.668 62.117 9.465 c 62.109 9.254 62.098 9.102\n"
                                         " 62.086 9.008 c 65.016 9.008 l 65.031 9.094 65.043 9.25 65.059 9.465 c 65.074\n"
                                         " 9.676 65.086 9.91 65.102 10.164 c 65.117 10.418 65.129 10.676 65.133 10.93\n"
                                         " c 65.148 11.176 65.156 11.379 65.156 11.531 c 65.199 11.531 l 65.352 11.102\n"
                                         " 65.504 10.719 65.656 10.383 c 65.809 10.039 65.988 9.754 66.191 9.52 c \n"
                                         "66.402 9.277 66.652 9.098 66.945 8.973 c 67.238 8.84 67.598 8.777 68.027\n"
                                         " 8.777 c 68.211 8.777 68.387 8.797 68.562 8.832 c 68.746 8.859 68.883 8.898\n"
                                         " 68.977 8.941 c 68.977 11.508 l 68.781 11.465 68.578 11.426 68.375 11.398\n"
                                         " c 68.18 11.363 67.941 11.344 67.664 11.344 c 66.898 11.344 66.301 11.652\n"
                                         " 65.871 12.273 c 65.449 12.895 65.238 13.809 65.238 15.027 c 65.238 20.828\n"
                                         " l 62.168 20.828 l 75.707 21.047 m 74.855 21.047 74.086 20.922 73.402 20.676\n"
                                         " c 72.727 20.422 72.145 20.039 71.664 19.527 c 71.184 19.012 70.816 18.367\n"
                                         " 70.559 17.594 c 70.305 16.812 70.176 15.902 70.176 14.863 c 70.176 13.734\n"
                                         " 70.324 12.785 70.625 12.012 c 70.93 11.238 71.34 10.617 71.848 10.145 c\n"
                                         " 72.363 9.664 72.957 9.316 73.629 9.105 c 74.301 8.895 75.004 8.789 75.75\n"
                                         " 8.789 c 76.684 8.789 77.477 8.953 78.133 9.281 c 78.797 9.602 79.34 10.055\n"
                                         " 79.762 10.637 c 80.184 11.219 80.492 11.918 80.691 12.734 c 80.887 13.543\n"
                                         " 80.988 14.438 80.988 15.422 c 80.988 15.508 l 73.41 15.508 l 73.41 16.004\n"
                                         " 73.453 16.465 73.543 16.895 c 73.629 17.316 73.773 17.684 73.969 18 c 74.164\n"
                                         " 18.305 74.422 18.551 74.734 18.73 c 75.047 18.906 75.426 18.992 75.871 \n"
                                         "18.992 c 76.41 18.992 76.852 18.879 77.191 18.652 c 77.535 18.418 77.777\n"
                                         " 18.062 77.922 17.582 c 80.816 17.832 l 80.684 18.168 80.5 18.523 80.258\n"
                                         " 18.902 c 80.023 19.281 79.711 19.629 79.316 19.953 c 78.922 20.266 78.43\n"
                                         " 20.527 77.84 20.738 c 77.258 20.941 76.547 21.043 75.711 21.043 c 75.711\n"
                                         " 10.719 m 75.398 10.719 75.102 10.773 74.824 10.883 c 74.555 10.984 74.316\n"
                                         " 11.152 74.113 11.387 c 73.918 11.613 73.758 11.906 73.633 12.273 c 73.508\n"
                                         " 12.637 73.441 13.074 73.426 13.586 c 78.016 13.586 l 77.957 12.633 77.727\n"
                                         " 11.918 77.328 11.445 c 76.926 10.965 76.387 10.723 75.711 10.723 c 90.988\n"
                                         " 20.828 m 90.973 20.77 90.957 20.668 90.934 20.523 c 90.918 20.371 90.902\n"
                                         " 20.199 90.879 20.012 c 90.863 19.824 90.852 19.629 90.836 19.434 c 90.828\n"
                                         " 19.238 90.824 19.062 90.824 18.91 c 90.781 18.91 l 90.426 19.676 89.926\n"
                                         " 20.227 89.285 20.559 c 88.652 20.887 87.891 21.051 87 21.051 c 86.258 21.051\n"
                                         " 85.613 20.898 85.066 20.594 c 84.527 20.289 84.078 19.863 83.723 19.316\n"
                                         " c 83.371 18.77 83.109 18.125 82.938 17.383 c 82.77 16.633 82.688 15.816\n"
                                         " 82.688 14.934 c 82.688 14.039 82.773 13.215 82.949 12.465 c 83.133 11.715\n"
                                         " 83.406 11.07 83.781 10.531 c 84.152 9.984 84.621 9.559 85.191 9.254 c 85.766\n"
                                         " 8.949 86.449 8.797 87.234 8.797 c 87.621 8.797 87.992 8.836 88.348 8.918\n"
                                         " c 88.703 9 89.035 9.121 89.344 9.289 c 89.648 9.457 89.926 9.672 90.176\n"
                                         " 9.934 c 90.422 10.195 90.633 10.512 90.809 10.883 c 90.832 10.883 l 90.832\n"
                                         " 10.809 90.828 10.703 90.82 10.566 c 90.82 10.422 90.82 10.258 90.82 10.074\n"
                                         " c 90.82 9.891 90.816 9.703 90.809 9.508 c 90.809 9.312 90.809 9.121 90.809\n"
                                         " 8.941 c 90.809 4.625 l 93.879 4.625 l 93.879 18.262 l 93.879 18.836 93.891\n"
                                         " 19.352 93.91 19.801 c 93.934 20.246 93.949 20.59 93.965 20.84 c 90.992 \n"
                                         "20.84 l 90.852 14.863 m 90.852 14.082 90.777 13.438 90.633 12.93 c 90.488\n"
                                         " 12.414 90.293 12.004 90.055 11.707 c 89.82 11.402 89.551 11.191 89.246 \n"
                                         "11.074 c 88.949 10.949 88.641 10.887 88.328 10.887 c 87.934 10.887 87.586\n"
                                         " 10.965 87.277 11.117 c 86.98 11.27 86.723 11.512 86.512 11.84 c 86.309 \n"
                                         "12.168 86.152 12.586 86.043 13.098 c 85.941 13.609 85.891 14.223 85.891 \n"
                                         "14.945 c 85.891 17.625 86.695 18.965 88.305 18.965 c 88.609 18.965 88.918\n"
                                         " 18.898 89.223 18.77 c 89.527 18.637 89.801 18.418 90.043 18.102 c 90.285\n"
                                         " 17.789 90.477 17.371 90.621 16.844 c 90.773 16.312 90.852 15.652 90.852\n"
                                         " 14.867 c S Q\n"
                                         "0.74902 0 0 rg 1 1 1 RG 0.797243 w\n"
                                         "1 J\n"
                                         "1 j\n"
                                         "q 1 0 0 1 0 0 cm\n"
                                         "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                         "24.715 1.77 26.086 3.398 26.086 c 103.359 26.086 l 104.988 26.086 106.359\n"
                                         " 24.715 106.359 23.086 c 106.359 3.398 l 106.359 1.77 104.988 0.398 103.359\n"
                                         " 0.398 c h\n"
                                         "3.867 3.844 m 102.914 3.844 l 102.914 22.617 l 3.867 22.617 l h\n"
                                         "3.867 3.844 m B Q\n"
                                         "Q\n";

static std::unique_ptr<Dict> getExpiredStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
