//========================================================================
//
// annot_stamp_experimental.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_EXPERIMENTAL_H
#define ANNOT_STAMP_EXPERIMENTAL_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_EXPERIMENTAL_WIDTH = 170.508179;
static const double ANNOT_STAMP_EXPERIMENTAL_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_EXPERIMENTAL = "1 0 0 -1 0 26.484741 cm\n"
                                              "q\n"
                                              "1 1 1 rg /a0 gs\n"
                                              "3.406 2.129 m 167.117 2.129 l 167.816 2.129 168.387 2.828 168.387 3.398\n"
                                              " c 168.387 23.09 l 168.387 23.789 167.82 24.359 167.117 24.359 c 3.406 24.359\n"
                                              " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                              " 2.129 3.406 2.129 c h\n"
                                              "3.406 2.129 m f\n"
                                              "0 0.298039 0.431373 rg /a1 gs\n"
                                              "14.82 20.828 m 14.82 5.434 l 26.926 5.434 l 26.926 7.926 l 18.043 7.926\n"
                                              " l 18.043 11.793 l 26.262 11.793 l 26.262 14.285 l 18.043 14.285 l 18.043\n"
                                              " 18.34 l 27.375 18.34 l 27.375 20.832 l 14.82 20.828 l 37.219 20.828 m 34.465\n"
                                              " 16.543 l 31.688 20.828 l 28.422 20.828 l 32.75 14.719 l 28.629 9.004 l \n"
                                              "31.941 9.004 l 34.465 12.871 l 36.977 9.004 l 40.309 9.004 l 36.188 14.688\n"
                                              " l 40.547 20.828 l 37.215 20.828 l 53.473 14.863 m 53.473 15.758 53.383 \n"
                                              "16.586 53.199 17.344 c 53.023 18.102 52.75 18.754 52.379 19.301 c 52.008\n"
                                              " 19.848 51.535 20.277 50.957 20.59 c 50.391 20.895 49.715 21.047 48.938 \n"
                                              "21.047 c 48.586 21.047 48.238 21.012 47.887 20.938 c 47.543 20.863 47.215\n"
                                              " 20.75 46.902 20.586 c 46.59 20.418 46.297 20.203 46.027 19.941 c 45.766\n"
                                              " 19.672 45.539 19.34 45.352 18.945 c 45.285 18.945 l 45.293 18.98 45.301\n"
                                              " 19.074 45.309 19.219 c 45.316 19.363 45.324 19.535 45.332 19.73 c 45.34\n"
                                              " 19.918 45.344 20.125 45.344 20.344 c 45.352 20.555 45.355 20.75 45.355 \n"
                                              "20.934 c 45.355 25.469 l 42.285 25.469 l 42.285 11.723 l 42.285 11.117 42.273\n"
                                              " 10.578 42.254 10.105 c 42.238 9.633 42.223 9.266 42.199 9 c 45.184 9 l \n"
                                              "45.199 9.051 45.211 9.148 45.227 9.297 c 45.25 9.441 45.262 9.609 45.27 \n"
                                              "9.801 c 45.285 9.988 45.297 10.188 45.301 10.391 c 45.309 10.594 45.312 \n"
                                              "10.773 45.312 10.926 c 45.355 10.926 l 45.727 10.145 46.238 9.59 46.887 \n"
                                              "9.254 c 47.535 8.918 48.285 8.75 49.137 8.75 c 49.887 8.75 50.535 8.902 \n"
                                              "51.082 9.207 c 51.629 9.512 52.078 9.934 52.426 10.473 c 52.781 11.012 53.047\n"
                                              " 11.656 53.211 12.406 c 53.387 13.148 53.473 13.965 53.473 14.855 c 50.27\n"
                                              " 14.855 m 50.27 13.508 50.066 12.512 49.656 11.863 c 49.25 11.207 48.641\n"
                                              " 10.879 47.832 10.879 c 47.527 10.879 47.219 10.945 46.914 11.074 c 46.617\n"
                                              " 11.199 46.348 11.418 46.105 11.73 c 45.871 12.035 45.68 12.453 45.527 12.977\n"
                                              " c 45.383 13.492 45.309 14.148 45.309 14.945 c 45.309 15.719 45.383 16.363\n"
                                              " 45.527 16.879 c 45.672 17.391 45.863 17.797 46.094 18.102 c 46.336 18.406\n"
                                              " 46.605 18.625 46.902 18.758 c 47.199 18.883 47.504 18.945 47.809 18.945\n"
                                              " c 48.203 18.945 48.551 18.867 48.859 18.715 c 49.164 18.555 49.422 18.312\n"
                                              " 49.625 17.984 c 49.836 17.648 49.996 17.223 50.105 16.707 c 50.215 16.191\n"
                                              " 50.27 15.574 50.27 14.859 c 60.805 21.043 m 59.953 21.043 59.184 20.918\n"
                                              " 58.5 20.672 c 57.824 20.418 57.242 20.035 56.762 19.523 c 56.281 19.008\n"
                                              " 55.914 18.363 55.656 17.59 c 55.402 16.809 55.273 15.898 55.273 14.859 \n"
                                              "c 55.273 13.73 55.422 12.781 55.723 12.008 c 56.027 11.234 56.438 10.613\n"
                                              " 56.945 10.141 c 57.461 9.66 58.055 9.312 58.727 9.102 c 59.398 8.891 60.102\n"
                                              " 8.785 60.848 8.785 c 61.781 8.785 62.574 8.949 63.23 9.277 c 63.895 9.598\n"
                                              " 64.438 10.051 64.859 10.633 c 65.281 11.215 65.59 11.914 65.789 12.73 c\n"
                                              " 65.984 13.539 66.086 14.434 66.086 15.418 c 66.086 15.504 l 58.504 15.508\n"
                                              " l 58.504 16.004 58.547 16.465 58.637 16.895 c 58.723 17.316 58.867 17.684\n"
                                              " 59.062 18 c 59.258 18.305 59.516 18.551 59.828 18.73 c 60.141 18.906 60.52\n"
                                              " 18.992 60.965 18.992 c 61.504 18.992 61.945 18.879 62.285 18.652 c 62.629\n"
                                              " 18.418 62.871 18.062 63.016 17.582 c 65.91 17.832 l 65.777 18.168 65.594\n"
                                              " 18.523 65.352 18.902 c 65.117 19.281 64.805 19.629 64.41 19.953 c 64.016\n"
                                              " 20.266 63.523 20.527 62.934 20.738 c 62.352 20.941 61.641 21.043 60.805\n"
                                              " 21.043 c 60.805 10.719 m 60.492 10.719 60.195 10.773 59.918 10.883 c 59.648\n"
                                              " 10.984 59.41 11.152 59.207 11.387 c 59.012 11.613 58.852 11.906 58.727 \n"
                                              "12.273 c 58.602 12.637 58.535 13.074 58.52 13.586 c 63.109 13.586 l 63.051\n"
                                              " 12.633 62.82 11.918 62.422 11.445 c 62.02 10.965 61.48 10.723 60.805 10.723\n"
                                              " c 68.422 20.828 m 68.422 11.781 l 68.422 11.527 68.418 11.258 68.41 10.973\n"
                                              " c 68.41 10.688 68.402 10.418 68.387 10.164 c 68.379 9.902 68.371 9.668 \n"
                                              "68.363 9.465 c 68.355 9.254 68.344 9.102 68.332 9.008 c 71.262 9.008 l 71.277\n"
                                              " 9.094 71.289 9.25 71.305 9.465 c 71.32 9.676 71.332 9.91 71.348 10.164 \n"
                                              "c 71.363 10.418 71.375 10.676 71.379 10.93 c 71.395 11.176 71.402 11.379\n"
                                              " 71.402 11.531 c 71.445 11.531 l 71.598 11.102 71.75 10.719 71.902 10.383\n"
                                              " c 72.055 10.039 72.234 9.754 72.438 9.52 c 72.648 9.277 72.898 9.098 73.191\n"
                                              " 8.973 c 73.484 8.84 73.844 8.777 74.273 8.777 c 74.457 8.777 74.633 8.797\n"
                                              " 74.809 8.832 c 74.992 8.859 75.129 8.898 75.223 8.941 c 75.223 11.508 l\n"
                                              " 75.027 11.465 74.824 11.426 74.621 11.398 c 74.426 11.363 74.188 11.344\n"
                                              " 73.91 11.344 c 73.145 11.344 72.547 11.652 72.117 12.273 c 71.695 12.895\n"
                                              " 71.484 13.809 71.484 15.027 c 71.484 20.828 l 68.426 20.828 l 77.125 6.875\n"
                                              " m 77.125 4.613 l 80.195 4.613 l 80.195 6.875 l 77.125 6.875 l 77.125 20.828\n"
                                              " m 77.125 9.004 l 80.195 9.004 l 80.195 20.828 l 77.125 20.828 l 90.293 \n"
                                              "20.828 m 90.293 14.195 l 90.293 13.738 90.262 13.316 90.195 12.938 c 90.137\n"
                                              " 12.551 90.035 12.223 89.891 11.953 c 89.754 11.676 89.566 11.461 89.332\n"
                                              " 11.309 c 89.105 11.156 88.828 11.078 88.5 11.078 c 88.188 11.078 87.902\n"
                                              " 11.16 87.648 11.328 c 87.395 11.488 87.172 11.723 86.98 12.027 c 86.797\n"
                                              " 12.324 86.656 12.688 86.555 13.109 c 86.453 13.523 86.402 13.984 86.402\n"
                                              " 14.484 c 86.402 20.82 l 83.332 20.82 l 83.332 11.641 l 83.332 11.387 83.328\n"
                                              " 11.125 83.32 10.855 c 83.32 10.586 83.312 10.332 83.297 10.09 c 83.289 \n"
                                              "9.844 83.281 9.625 83.273 9.434 c 83.266 9.238 83.254 9.09 83.242 8.996 \n"
                                              "c 86.172 8.996 l 86.188 9.082 86.199 9.227 86.215 9.422 c 86.23 9.609 86.242\n"
                                              " 9.824 86.258 10.055 c 86.273 10.289 86.285 10.52 86.289 10.754 c 86.305\n"
                                              " 10.988 86.312 11.184 86.312 11.344 c 86.355 11.344 l 86.734 10.441 87.203\n"
                                              " 9.785 87.766 9.375 c 88.332 8.969 89.012 8.762 89.797 8.762 c 90.699 8.762\n"
                                              " 91.426 8.984 91.973 9.43 c 92.527 9.867 92.898 10.504 93.086 11.344 c 93.152\n"
                                              " 11.344 l 93.363 10.855 93.59 10.449 93.828 10.121 c 94.074 9.793 94.344\n"
                                              " 9.531 94.637 9.336 c 94.934 9.133 95.258 8.984 95.598 8.898 c 95.949 8.812\n"
                                              " 96.324 8.766 96.734 8.766 c 97.383 8.766 97.93 8.883 98.375 9.117 c 98.828\n"
                                              " 9.352 99.191 9.672 99.469 10.078 c 99.754 10.484 99.957 10.969 100.082 \n"
                                              "11.52 c 100.215 12.074 100.277 12.672 100.277 13.312 c 100.277 20.82 l 97.23\n"
                                              " 20.82 l 97.23 14.188 l 97.23 13.73 97.199 13.309 97.133 12.93 c 97.074 \n"
                                              "12.543 96.973 12.215 96.828 11.945 c 96.691 11.668 96.504 11.453 96.27 11.301\n"
                                              " c 96.043 11.148 95.766 11.07 95.438 11.07 c 95.133 11.07 94.852 11.152 \n"
                                              "94.598 11.312 c 94.352 11.465 94.133 11.688 93.941 11.98 c 93.758 12.266\n"
                                              " 93.617 12.605 93.516 13.008 c 93.414 13.41 93.355 13.852 93.34 14.34 c \n"
                                              "93.34 20.82 l 90.293 20.82 l 108.059 21.039 m 107.207 21.039 106.438 20.914\n"
                                              " 105.754 20.668 c 105.078 20.414 104.496 20.031 104.016 19.52 c 103.535 \n"
                                              "19.004 103.168 18.359 102.91 17.586 c 102.656 16.805 102.527 15.895 102.527\n"
                                              " 14.855 c 102.527 13.727 102.676 12.777 102.977 12.004 c 103.281 11.23 103.691\n"
                                              " 10.609 104.199 10.137 c 104.715 9.656 105.309 9.309 105.98 9.098 c 106.652\n"
                                              " 8.887 107.355 8.781 108.102 8.781 c 109.035 8.781 109.828 8.945 110.484\n"
                                              " 9.273 c 111.148 9.594 111.691 10.047 112.113 10.629 c 112.535 11.211 112.844\n"
                                              " 11.91 113.043 12.727 c 113.238 13.535 113.34 14.43 113.34 15.414 c 113.34\n"
                                              " 15.5 l 105.754 15.508 l 105.754 16.004 105.797 16.465 105.887 16.895 c \n"
                                              "105.973 17.316 106.117 17.684 106.312 18 c 106.508 18.305 106.766 18.551\n"
                                              " 107.078 18.73 c 107.391 18.906 107.77 18.992 108.215 18.992 c 108.754 18.992\n"
                                              " 109.195 18.879 109.535 18.652 c 109.879 18.418 110.121 18.062 110.266 17.582\n"
                                              " c 113.16 17.832 l 113.027 18.168 112.844 18.523 112.602 18.902 c 112.367\n"
                                              " 19.281 112.055 19.629 111.66 19.953 c 111.266 20.266 110.773 20.527 110.184\n"
                                              " 20.738 c 109.602 20.941 108.891 21.043 108.055 21.043 c 108.055 10.719 \n"
                                              "m 107.742 10.719 107.445 10.773 107.168 10.883 c 106.898 10.984 106.66 11.152\n"
                                              " 106.457 11.387 c 106.262 11.613 106.102 11.906 105.977 12.273 c 105.852\n"
                                              " 12.637 105.785 13.074 105.77 13.586 c 110.359 13.586 l 110.301 12.633 110.07\n"
                                              " 11.918 109.672 11.445 c 109.27 10.965 108.73 10.723 108.055 10.723 c 123.332\n"
                                              " 20.828 m 123.332 14.195 l 123.332 13.738 123.297 13.316 123.223 12.938 \n"
                                              "c 123.148 12.551 123.031 12.223 122.863 11.953 c 122.695 11.676 122.477 \n"
                                              "11.461 122.207 11.309 c 121.938 11.156 121.609 11.078 121.223 11.078 c 120.852\n"
                                              " 11.078 120.512 11.16 120.207 11.328 c 119.91 11.488 119.648 11.723 119.43\n"
                                              " 12.027 c 119.211 12.324 119.039 12.688 118.918 13.109 c 118.801 13.523 \n"
                                              "118.742 13.984 118.742 14.484 c 118.742 20.82 l 115.672 20.82 l 115.672 \n"
                                              "11.641 l 115.672 11.387 115.668 11.125 115.66 10.855 c 115.66 10.586 115.652\n"
                                              " 10.332 115.637 10.09 c 115.629 9.844 115.621 9.625 115.613 9.434 c 115.605\n"
                                              " 9.238 115.594 9.09 115.582 8.996 c 118.512 8.996 l 118.527 9.082 118.539\n"
                                              " 9.227 118.555 9.422 c 118.57 9.609 118.582 9.824 118.598 10.055 c 118.613\n"
                                              " 10.289 118.625 10.52 118.629 10.754 c 118.645 10.988 118.652 11.184 118.652\n"
                                              " 11.344 c 118.695 11.344 l 119.109 10.441 119.633 9.785 120.258 9.375 c \n"
                                              "120.883 8.969 121.633 8.762 122.496 8.762 c 123.211 8.762 123.812 8.879 \n"
                                              "124.301 9.113 c 124.797 9.348 125.195 9.668 125.504 10.074 c 125.816 10.48\n"
                                              " 126.043 10.965 126.18 11.516 c 126.316 12.07 126.387 12.668 126.387 13.309\n"
                                              " c 126.387 20.816 l 123.328 20.816 l 132.375 21.012 m 131.473 21.012 130.777\n"
                                              " 20.77 130.289 20.281 c 129.801 19.785 129.559 19.039 129.559 18.043 c 129.559\n"
                                              " 11.07 l 128.062 11.07 l 128.062 8.996 l 129.711 8.996 l 130.672 6.219 l\n"
                                              " 132.594 6.219 l 132.594 8.996 l 134.832 8.996 l 134.832 11.07 l 132.594\n"
                                              " 11.07 l 132.594 17.211 l 132.594 17.785 132.703 18.211 132.922 18.488 c\n"
                                              " 133.141 18.758 133.48 18.895 133.938 18.891 c 134.125 18.891 134.297 18.875\n"
                                              " 134.449 18.848 c 134.602 18.82 134.773 18.781 134.961 18.738 c 134.961 \n"
                                              "20.641 l 134.582 20.766 134.18 20.855 133.758 20.914 c 133.336 20.98 132.871\n"
                                              " 21.012 132.371 21.012 c 139.551 21.035 m 138.984 21.035 138.473 20.957 \n"
                                              "138.02 20.805 c 137.574 20.645 137.195 20.414 136.883 20.117 c 136.57 19.812\n"
                                              " 136.328 19.438 136.16 18.992 c 135.992 18.547 135.91 18.043 135.91 17.473\n"
                                              " c 135.91 16.773 136.031 16.188 136.27 15.715 c 136.516 15.234 136.852 14.848\n"
                                              " 137.273 14.555 c 137.695 14.258 138.191 14.043 138.758 13.91 c 139.324 \n"
                                              "13.773 139.93 13.699 140.57 13.691 c 143.117 13.648 l 143.117 13.047 l 143.117\n"
                                              " 12.617 143.078 12.262 142.996 11.977 c 142.922 11.684 142.812 11.449 142.668\n"
                                              " 11.266 c 142.523 11.082 142.34 10.957 142.121 10.883 c 141.91 10.801 141.664\n"
                                              " 10.762 141.391 10.762 c 141.137 10.762 140.906 10.789 140.703 10.84 c 140.508\n"
                                              " 10.891 140.336 10.98 140.191 11.113 c 140.047 11.238 139.926 11.41 139.832\n"
                                              " 11.625 c 139.746 11.836 139.684 12.105 139.645 12.434 c 136.441 12.281 \n"
                                              "l 136.527 11.766 136.688 11.293 136.922 10.871 c 137.156 10.441 137.477 \n"
                                              "10.07 137.883 9.758 c 138.297 9.445 138.805 9.203 139.402 9.035 c 140.008\n"
                                              " 8.859 140.715 8.773 141.523 8.773 c 142.258 8.773 142.914 8.863 143.492\n"
                                              " 9.047 c 144.066 9.23 144.555 9.504 144.957 9.867 c 145.359 10.223 145.664\n"
                                              " 10.664 145.875 11.188 c 146.086 11.711 146.191 12.32 146.191 13.012 c 146.191\n"
                                              " 17.316 l 146.191 17.594 146.203 17.84 146.223 18.059 c 146.25 18.277 146.301\n"
                                              " 18.461 146.363 18.617 c 146.438 18.762 146.535 18.875 146.66 18.957 c 146.793\n"
                                              " 19.031 146.957 19.066 147.164 19.066 c 147.398 19.066 147.621 19.043 147.84\n"
                                              " 19 c 147.84 20.66 l 147.656 20.703 147.492 20.742 147.348 20.781 c 147.203\n"
                                              " 20.816 147.055 20.848 146.91 20.867 c 146.766 20.891 146.609 20.906 146.441\n"
                                              " 20.922 c 146.281 20.938 146.09 20.945 145.875 20.945 c 145.102 20.945 144.531\n"
                                              " 20.758 144.16 20.379 c 143.797 20 143.578 19.441 143.504 18.707 c 143.438\n"
                                              " 18.707 l 143.031 19.441 142.504 20.016 141.863 20.422 c 141.23 20.828 140.457\n"
                                              " 21.035 139.547 21.035 c 143.121 15.344 m 141.547 15.367 l 141.219 15.383\n"
                                              " 140.906 15.41 140.605 15.453 c 140.312 15.488 140.055 15.574 139.828 15.703\n"
                                              " c 139.609 15.828 139.434 16.008 139.305 16.25 c 139.172 16.492 139.109 \n"
                                              "16.816 139.109 17.234 c 139.109 17.797 139.238 18.215 139.492 18.492 c 139.754\n"
                                              " 18.762 140.102 18.898 140.531 18.895 c 140.926 18.895 141.281 18.812 141.602\n"
                                              " 18.645 c 141.922 18.477 142.191 18.258 142.41 17.988 c 142.637 17.711 142.812\n"
                                              " 17.395 142.934 17.039 c 143.059 16.684 143.121 16.316 143.121 15.945 c \n"
                                              "143.121 15.344 l 149.273 20.816 m 149.273 4.602 l 152.344 4.602 l 152.344\n"
                                              " 20.816 l 149.273 20.816 l f\n"
                                              "1 1 1 RG 0.531496 w\n"
                                              "0 J\n"
                                              "0 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "14.82 20.828 m 14.82 5.434 l 26.926 5.434 l 26.926 7.926 l 18.043 7.926\n"
                                              " l 18.043 11.793 l 26.262 11.793 l 26.262 14.285 l 18.043 14.285 l 18.043\n"
                                              " 18.34 l 27.375 18.34 l 27.375 20.832 l 14.82 20.828 l 37.219 20.828 m 34.465\n"
                                              " 16.543 l 31.688 20.828 l 28.422 20.828 l 32.75 14.719 l 28.629 9.004 l \n"
                                              "31.941 9.004 l 34.465 12.871 l 36.977 9.004 l 40.309 9.004 l 36.188 14.688\n"
                                              " l 40.547 20.828 l 37.215 20.828 l 53.473 14.863 m 53.473 15.758 53.383 \n"
                                              "16.586 53.199 17.344 c 53.023 18.102 52.75 18.754 52.379 19.301 c 52.008\n"
                                              " 19.848 51.535 20.277 50.957 20.59 c 50.391 20.895 49.715 21.047 48.938 \n"
                                              "21.047 c 48.586 21.047 48.238 21.012 47.887 20.938 c 47.543 20.863 47.215\n"
                                              " 20.75 46.902 20.586 c 46.59 20.418 46.297 20.203 46.027 19.941 c 45.766\n"
                                              " 19.672 45.539 19.34 45.352 18.945 c 45.285 18.945 l 45.293 18.98 45.301\n"
                                              " 19.074 45.309 19.219 c 45.316 19.363 45.324 19.535 45.332 19.73 c 45.34\n"
                                              " 19.918 45.344 20.125 45.344 20.344 c 45.352 20.555 45.355 20.75 45.355 \n"
                                              "20.934 c 45.355 25.469 l 42.285 25.469 l 42.285 11.723 l 42.285 11.117 42.273\n"
                                              " 10.578 42.254 10.105 c 42.238 9.633 42.223 9.266 42.199 9 c 45.184 9 l \n"
                                              "45.199 9.051 45.211 9.148 45.227 9.297 c 45.25 9.441 45.262 9.609 45.27 \n"
                                              "9.801 c 45.285 9.988 45.297 10.188 45.301 10.391 c 45.309 10.594 45.312 \n"
                                              "10.773 45.312 10.926 c 45.355 10.926 l 45.727 10.145 46.238 9.59 46.887 \n"
                                              "9.254 c 47.535 8.918 48.285 8.75 49.137 8.75 c 49.887 8.75 50.535 8.902 \n"
                                              "51.082 9.207 c 51.629 9.512 52.078 9.934 52.426 10.473 c 52.781 11.012 53.047\n"
                                              " 11.656 53.211 12.406 c 53.387 13.148 53.473 13.965 53.473 14.855 c 50.27\n"
                                              " 14.855 m 50.27 13.508 50.066 12.512 49.656 11.863 c 49.25 11.207 48.641\n"
                                              " 10.879 47.832 10.879 c 47.527 10.879 47.219 10.945 46.914 11.074 c 46.617\n"
                                              " 11.199 46.348 11.418 46.105 11.73 c 45.871 12.035 45.68 12.453 45.527 12.977\n"
                                              " c 45.383 13.492 45.309 14.148 45.309 14.945 c 45.309 15.719 45.383 16.363\n"
                                              " 45.527 16.879 c 45.672 17.391 45.863 17.797 46.094 18.102 c 46.336 18.406\n"
                                              " 46.605 18.625 46.902 18.758 c 47.199 18.883 47.504 18.945 47.809 18.945\n"
                                              " c 48.203 18.945 48.551 18.867 48.859 18.715 c 49.164 18.555 49.422 18.312\n"
                                              " 49.625 17.984 c 49.836 17.648 49.996 17.223 50.105 16.707 c 50.215 16.191\n"
                                              " 50.27 15.574 50.27 14.859 c 60.805 21.043 m 59.953 21.043 59.184 20.918\n"
                                              " 58.5 20.672 c 57.824 20.418 57.242 20.035 56.762 19.523 c 56.281 19.008\n"
                                              " 55.914 18.363 55.656 17.59 c 55.402 16.809 55.273 15.898 55.273 14.859 \n"
                                              "c 55.273 13.73 55.422 12.781 55.723 12.008 c 56.027 11.234 56.438 10.613\n"
                                              " 56.945 10.141 c 57.461 9.66 58.055 9.312 58.727 9.102 c 59.398 8.891 60.102\n"
                                              " 8.785 60.848 8.785 c 61.781 8.785 62.574 8.949 63.23 9.277 c 63.895 9.598\n"
                                              " 64.438 10.051 64.859 10.633 c 65.281 11.215 65.59 11.914 65.789 12.73 c\n"
                                              " 65.984 13.539 66.086 14.434 66.086 15.418 c 66.086 15.504 l 58.504 15.508\n"
                                              " l 58.504 16.004 58.547 16.465 58.637 16.895 c 58.723 17.316 58.867 17.684\n"
                                              " 59.062 18 c 59.258 18.305 59.516 18.551 59.828 18.73 c 60.141 18.906 60.52\n"
                                              " 18.992 60.965 18.992 c 61.504 18.992 61.945 18.879 62.285 18.652 c 62.629\n"
                                              " 18.418 62.871 18.062 63.016 17.582 c 65.91 17.832 l 65.777 18.168 65.594\n"
                                              " 18.523 65.352 18.902 c 65.117 19.281 64.805 19.629 64.41 19.953 c 64.016\n"
                                              " 20.266 63.523 20.527 62.934 20.738 c 62.352 20.941 61.641 21.043 60.805\n"
                                              " 21.043 c 60.805 10.719 m 60.492 10.719 60.195 10.773 59.918 10.883 c 59.648\n"
                                              " 10.984 59.41 11.152 59.207 11.387 c 59.012 11.613 58.852 11.906 58.727 \n"
                                              "12.273 c 58.602 12.637 58.535 13.074 58.52 13.586 c 63.109 13.586 l 63.051\n"
                                              " 12.633 62.82 11.918 62.422 11.445 c 62.02 10.965 61.48 10.723 60.805 10.723\n"
                                              " c 68.422 20.828 m 68.422 11.781 l 68.422 11.527 68.418 11.258 68.41 10.973\n"
                                              " c 68.41 10.688 68.402 10.418 68.387 10.164 c 68.379 9.902 68.371 9.668 \n"
                                              "68.363 9.465 c 68.355 9.254 68.344 9.102 68.332 9.008 c 71.262 9.008 l 71.277\n"
                                              " 9.094 71.289 9.25 71.305 9.465 c 71.32 9.676 71.332 9.91 71.348 10.164 \n"
                                              "c 71.363 10.418 71.375 10.676 71.379 10.93 c 71.395 11.176 71.402 11.379\n"
                                              " 71.402 11.531 c 71.445 11.531 l 71.598 11.102 71.75 10.719 71.902 10.383\n"
                                              " c 72.055 10.039 72.234 9.754 72.438 9.52 c 72.648 9.277 72.898 9.098 73.191\n"
                                              " 8.973 c 73.484 8.84 73.844 8.777 74.273 8.777 c 74.457 8.777 74.633 8.797\n"
                                              " 74.809 8.832 c 74.992 8.859 75.129 8.898 75.223 8.941 c 75.223 11.508 l\n"
                                              " 75.027 11.465 74.824 11.426 74.621 11.398 c 74.426 11.363 74.188 11.344\n"
                                              " 73.91 11.344 c 73.145 11.344 72.547 11.652 72.117 12.273 c 71.695 12.895\n"
                                              " 71.484 13.809 71.484 15.027 c 71.484 20.828 l 68.426 20.828 l 77.125 6.875\n"
                                              " m 77.125 4.613 l 80.195 4.613 l 80.195 6.875 l 77.125 6.875 l 77.125 20.828\n"
                                              " m 77.125 9.004 l 80.195 9.004 l 80.195 20.828 l 77.125 20.828 l 90.293 \n"
                                              "20.828 m 90.293 14.195 l 90.293 13.738 90.262 13.316 90.195 12.938 c 90.137\n"
                                              " 12.551 90.035 12.223 89.891 11.953 c 89.754 11.676 89.566 11.461 89.332\n"
                                              " 11.309 c 89.105 11.156 88.828 11.078 88.5 11.078 c 88.188 11.078 87.902\n"
                                              " 11.16 87.648 11.328 c 87.395 11.488 87.172 11.723 86.98 12.027 c 86.797\n"
                                              " 12.324 86.656 12.688 86.555 13.109 c 86.453 13.523 86.402 13.984 86.402\n"
                                              " 14.484 c 86.402 20.82 l 83.332 20.82 l 83.332 11.641 l 83.332 11.387 83.328\n"
                                              " 11.125 83.32 10.855 c 83.32 10.586 83.312 10.332 83.297 10.09 c 83.289 \n"
                                              "9.844 83.281 9.625 83.273 9.434 c 83.266 9.238 83.254 9.09 83.242 8.996 \n"
                                              "c 86.172 8.996 l 86.188 9.082 86.199 9.227 86.215 9.422 c 86.23 9.609 86.242\n"
                                              " 9.824 86.258 10.055 c 86.273 10.289 86.285 10.52 86.289 10.754 c 86.305\n"
                                              " 10.988 86.312 11.184 86.312 11.344 c 86.355 11.344 l 86.734 10.441 87.203\n"
                                              " 9.785 87.766 9.375 c 88.332 8.969 89.012 8.762 89.797 8.762 c 90.699 8.762\n"
                                              " 91.426 8.984 91.973 9.43 c 92.527 9.867 92.898 10.504 93.086 11.344 c 93.152\n"
                                              " 11.344 l 93.363 10.855 93.59 10.449 93.828 10.121 c 94.074 9.793 94.344\n"
                                              " 9.531 94.637 9.336 c 94.934 9.133 95.258 8.984 95.598 8.898 c 95.949 8.812\n"
                                              " 96.324 8.766 96.734 8.766 c 97.383 8.766 97.93 8.883 98.375 9.117 c 98.828\n"
                                              " 9.352 99.191 9.672 99.469 10.078 c 99.754 10.484 99.957 10.969 100.082 \n"
                                              "11.52 c 100.215 12.074 100.277 12.672 100.277 13.312 c 100.277 20.82 l 97.23\n"
                                              " 20.82 l 97.23 14.188 l 97.23 13.73 97.199 13.309 97.133 12.93 c 97.074 \n"
                                              "12.543 96.973 12.215 96.828 11.945 c 96.691 11.668 96.504 11.453 96.27 11.301\n"
                                              " c 96.043 11.148 95.766 11.07 95.438 11.07 c 95.133 11.07 94.852 11.152 \n"
                                              "94.598 11.312 c 94.352 11.465 94.133 11.688 93.941 11.98 c 93.758 12.266\n"
                                              " 93.617 12.605 93.516 13.008 c 93.414 13.41 93.355 13.852 93.34 14.34 c \n"
                                              "93.34 20.82 l 90.293 20.82 l 108.059 21.039 m 107.207 21.039 106.438 20.914\n"
                                              " 105.754 20.668 c 105.078 20.414 104.496 20.031 104.016 19.52 c 103.535 \n"
                                              "19.004 103.168 18.359 102.91 17.586 c 102.656 16.805 102.527 15.895 102.527\n"
                                              " 14.855 c 102.527 13.727 102.676 12.777 102.977 12.004 c 103.281 11.23 103.691\n"
                                              " 10.609 104.199 10.137 c 104.715 9.656 105.309 9.309 105.98 9.098 c 106.652\n"
                                              " 8.887 107.355 8.781 108.102 8.781 c 109.035 8.781 109.828 8.945 110.484\n"
                                              " 9.273 c 111.148 9.594 111.691 10.047 112.113 10.629 c 112.535 11.211 112.844\n"
                                              " 11.91 113.043 12.727 c 113.238 13.535 113.34 14.43 113.34 15.414 c 113.34\n"
                                              " 15.5 l 105.754 15.508 l 105.754 16.004 105.797 16.465 105.887 16.895 c \n"
                                              "105.973 17.316 106.117 17.684 106.312 18 c 106.508 18.305 106.766 18.551\n"
                                              " 107.078 18.73 c 107.391 18.906 107.77 18.992 108.215 18.992 c 108.754 18.992\n"
                                              " 109.195 18.879 109.535 18.652 c 109.879 18.418 110.121 18.062 110.266 17.582\n"
                                              " c 113.16 17.832 l 113.027 18.168 112.844 18.523 112.602 18.902 c 112.367\n"
                                              " 19.281 112.055 19.629 111.66 19.953 c 111.266 20.266 110.773 20.527 110.184\n"
                                              " 20.738 c 109.602 20.941 108.891 21.043 108.055 21.043 c 108.055 10.719 \n"
                                              "m 107.742 10.719 107.445 10.773 107.168 10.883 c 106.898 10.984 106.66 11.152\n"
                                              " 106.457 11.387 c 106.262 11.613 106.102 11.906 105.977 12.273 c 105.852\n"
                                              " 12.637 105.785 13.074 105.77 13.586 c 110.359 13.586 l 110.301 12.633 110.07\n"
                                              " 11.918 109.672 11.445 c 109.27 10.965 108.73 10.723 108.055 10.723 c 123.332\n"
                                              " 20.828 m 123.332 14.195 l 123.332 13.738 123.297 13.316 123.223 12.938 \n"
                                              "c 123.148 12.551 123.031 12.223 122.863 11.953 c 122.695 11.676 122.477 \n"
                                              "11.461 122.207 11.309 c 121.938 11.156 121.609 11.078 121.223 11.078 c 120.852\n"
                                              " 11.078 120.512 11.16 120.207 11.328 c 119.91 11.488 119.648 11.723 119.43\n"
                                              " 12.027 c 119.211 12.324 119.039 12.688 118.918 13.109 c 118.801 13.523 \n"
                                              "118.742 13.984 118.742 14.484 c 118.742 20.82 l 115.672 20.82 l 115.672 \n"
                                              "11.641 l 115.672 11.387 115.668 11.125 115.66 10.855 c 115.66 10.586 115.652\n"
                                              " 10.332 115.637 10.09 c 115.629 9.844 115.621 9.625 115.613 9.434 c 115.605\n"
                                              " 9.238 115.594 9.09 115.582 8.996 c 118.512 8.996 l 118.527 9.082 118.539\n"
                                              " 9.227 118.555 9.422 c 118.57 9.609 118.582 9.824 118.598 10.055 c 118.613\n"
                                              " 10.289 118.625 10.52 118.629 10.754 c 118.645 10.988 118.652 11.184 118.652\n"
                                              " 11.344 c 118.695 11.344 l 119.109 10.441 119.633 9.785 120.258 9.375 c \n"
                                              "120.883 8.969 121.633 8.762 122.496 8.762 c 123.211 8.762 123.812 8.879 \n"
                                              "124.301 9.113 c 124.797 9.348 125.195 9.668 125.504 10.074 c 125.816 10.48\n"
                                              " 126.043 10.965 126.18 11.516 c 126.316 12.07 126.387 12.668 126.387 13.309\n"
                                              " c 126.387 20.816 l 123.328 20.816 l 132.375 21.012 m 131.473 21.012 130.777\n"
                                              " 20.77 130.289 20.281 c 129.801 19.785 129.559 19.039 129.559 18.043 c 129.559\n"
                                              " 11.07 l 128.062 11.07 l 128.062 8.996 l 129.711 8.996 l 130.672 6.219 l\n"
                                              " 132.594 6.219 l 132.594 8.996 l 134.832 8.996 l 134.832 11.07 l 132.594\n"
                                              " 11.07 l 132.594 17.211 l 132.594 17.785 132.703 18.211 132.922 18.488 c\n"
                                              " 133.141 18.758 133.48 18.895 133.938 18.891 c 134.125 18.891 134.297 18.875\n"
                                              " 134.449 18.848 c 134.602 18.82 134.773 18.781 134.961 18.738 c 134.961 \n"
                                              "20.641 l 134.582 20.766 134.18 20.855 133.758 20.914 c 133.336 20.98 132.871\n"
                                              " 21.012 132.371 21.012 c 139.551 21.035 m 138.984 21.035 138.473 20.957 \n"
                                              "138.02 20.805 c 137.574 20.645 137.195 20.414 136.883 20.117 c 136.57 19.812\n"
                                              " 136.328 19.438 136.16 18.992 c 135.992 18.547 135.91 18.043 135.91 17.473\n"
                                              " c 135.91 16.773 136.031 16.188 136.27 15.715 c 136.516 15.234 136.852 14.848\n"
                                              " 137.273 14.555 c 137.695 14.258 138.191 14.043 138.758 13.91 c 139.324 \n"
                                              "13.773 139.93 13.699 140.57 13.691 c 143.117 13.648 l 143.117 13.047 l 143.117\n"
                                              " 12.617 143.078 12.262 142.996 11.977 c 142.922 11.684 142.812 11.449 142.668\n"
                                              " 11.266 c 142.523 11.082 142.34 10.957 142.121 10.883 c 141.91 10.801 141.664\n"
                                              " 10.762 141.391 10.762 c 141.137 10.762 140.906 10.789 140.703 10.84 c 140.508\n"
                                              " 10.891 140.336 10.98 140.191 11.113 c 140.047 11.238 139.926 11.41 139.832\n"
                                              " 11.625 c 139.746 11.836 139.684 12.105 139.645 12.434 c 136.441 12.281 \n"
                                              "l 136.527 11.766 136.688 11.293 136.922 10.871 c 137.156 10.441 137.477 \n"
                                              "10.07 137.883 9.758 c 138.297 9.445 138.805 9.203 139.402 9.035 c 140.008\n"
                                              " 8.859 140.715 8.773 141.523 8.773 c 142.258 8.773 142.914 8.863 143.492\n"
                                              " 9.047 c 144.066 9.23 144.555 9.504 144.957 9.867 c 145.359 10.223 145.664\n"
                                              " 10.664 145.875 11.188 c 146.086 11.711 146.191 12.32 146.191 13.012 c 146.191\n"
                                              " 17.316 l 146.191 17.594 146.203 17.84 146.223 18.059 c 146.25 18.277 146.301\n"
                                              " 18.461 146.363 18.617 c 146.438 18.762 146.535 18.875 146.66 18.957 c 146.793\n"
                                              " 19.031 146.957 19.066 147.164 19.066 c 147.398 19.066 147.621 19.043 147.84\n"
                                              " 19 c 147.84 20.66 l 147.656 20.703 147.492 20.742 147.348 20.781 c 147.203\n"
                                              " 20.816 147.055 20.848 146.91 20.867 c 146.766 20.891 146.609 20.906 146.441\n"
                                              " 20.922 c 146.281 20.938 146.09 20.945 145.875 20.945 c 145.102 20.945 144.531\n"
                                              " 20.758 144.16 20.379 c 143.797 20 143.578 19.441 143.504 18.707 c 143.438\n"
                                              " 18.707 l 143.031 19.441 142.504 20.016 141.863 20.422 c 141.23 20.828 140.457\n"
                                              " 21.035 139.547 21.035 c 143.121 15.344 m 141.547 15.367 l 141.219 15.383\n"
                                              " 140.906 15.41 140.605 15.453 c 140.312 15.488 140.055 15.574 139.828 15.703\n"
                                              " c 139.609 15.828 139.434 16.008 139.305 16.25 c 139.172 16.492 139.109 \n"
                                              "16.816 139.109 17.234 c 139.109 17.797 139.238 18.215 139.492 18.492 c 139.754\n"
                                              " 18.762 140.102 18.898 140.531 18.895 c 140.926 18.895 141.281 18.812 141.602\n"
                                              " 18.645 c 141.922 18.477 142.191 18.258 142.41 17.988 c 142.637 17.711 142.812\n"
                                              " 17.395 142.934 17.039 c 143.059 16.684 143.121 16.316 143.121 15.945 c \n"
                                              "143.121 15.344 l 149.273 20.816 m 149.273 4.602 l 152.344 4.602 l 152.344\n"
                                              " 20.816 l 149.273 20.816 l S Q\n"
                                              "Q q\n"
                                              "0 0.298039 0.431373 rg /a1 gs\n"
                                              "1 1 1 RG 0.797243 w\n"
                                              "1 J\n"
                                              "1 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                              "24.715 1.77 26.086 3.398 26.086 c 167.109 26.086 l 168.738 26.086 170.109\n"
                                              " 24.715 170.109 23.086 c 170.109 3.398 l 170.109 1.77 168.738 0.398 167.109\n"
                                              " 0.398 c h\n"
                                              "3.867 3.844 m 166.664 3.844 l 166.664 22.617 l 3.867 22.617 l h\n"
                                              "3.867 3.844 m B Q\n"
                                              "Q\n";

static std::unique_ptr<Dict> getExperimentalStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
