//========================================================================
//
// annot_stamp_confidential.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_CONFIDENTIAL_H
#define ANNOT_STAMP_CONFIDENTIAL_H

#include "PDFDoc.h"
#include "Dict.h"
#include "Object.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_CONFIDENTIAL_WIDTH = 155.508179;
static const double ANNOT_STAMP_CONFIDENTIAL_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_CONFIDENTIAL = "1 0 0 -1 0 26.484741 cm\n"
                                              "q\n"
                                              "1 1 1 rg /a0 gs\n"
                                              "3.406 2.129 m 152.117 2.129 l 152.82 2.129 153.387 2.695 153.387 3.398 \n"
                                              "c 153.387 23.09 l 153.387 23.793 152.82 24.359 152.117 24.359 c 3.406 24.355\n"
                                              " l 2.703 24.355 2.137 23.789 2.137 23.086 c 2.137 3.395 l 2.137 2.691 2.703\n"
                                              " 2.125 3.406 2.125 c h\n"
                                              "3.406 2.129 m f\n"
                                              "0.74902 0 0 rg /a1 gs\n"
                                              "1 1 1 RG 0.531496 w\n"
                                              "0 J\n"
                                              "0 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "22.008 18.512 m 23.953 18.512 25.305 17.535 26.062 15.582 c 28.871 16.641\n"
                                              " l 28.266 18.125 27.379 19.234 26.203 19.961 c 25.039 20.684 23.641 21.043\n"
                                              " 22.008 21.043 c 19.531 21.043 17.613 20.344 16.262 18.945 c 14.914 17.539\n"
                                              " 14.242 15.578 14.242 13.055 c 14.242 10.527 14.895 8.586 16.199 7.23 c \n"
                                              "17.504 5.875 19.395 5.199 21.871 5.199 c 23.676 5.199 25.148 5.562 26.285\n"
                                              " 6.293 c 27.422 7.016 28.219 8.078 28.68 9.484 c 25.84 10.262 l 25.598 9.488\n"
                                              " 25.125 8.879 24.418 8.426 c 23.719 7.969 22.891 7.738 21.938 7.738 c 20.48\n"
                                              " 7.738 19.375 8.191 18.617 9.094 c 17.867 9.996 17.492 11.32 17.492 13.059\n"
                                              " c 17.492 14.828 17.879 16.18 18.652 17.113 c 19.434 18.047 20.555 18.512\n"
                                              " 22.02 18.512 c h\n"
                                              "22.008 18.512 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "42.277 14.906 m 42.277 16.82 41.746 18.328 40.684 19.418 c 39.621 20.504\n"
                                              " 38.148 21.047 36.27 21.047 c 34.426 21.047 32.98 20.5 31.93 19.406 c 30.879\n"
                                              " 18.312 30.355 16.812 30.355 14.906 c 30.355 13.004 30.879 11.512 31.93 \n"
                                              "10.426 c 32.98 9.332 34.445 8.785 36.332 8.785 c 38.262 8.785 39.734 9.312\n"
                                              " 40.746 10.371 c 41.766 11.422 42.277 12.93 42.277 14.906 c h\n"
                                              "39.066 14.906 m 39.066 13.5 38.836 12.48 38.379 11.848 c 37.922 11.215 \n"
                                              "37.254 10.898 36.379 10.898 c 34.516 10.898 33.582 12.234 33.582 14.91 c\n"
                                              " 33.582 16.23 33.809 17.234 34.258 17.926 c 34.715 18.609 35.375 18.953 \n"
                                              "36.234 18.953 c 38.121 18.953 39.062 17.605 39.062 14.91 c h\n"
                                              "39.066 14.906 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "52.375 20.828 m 52.375 14.195 l 52.375 12.121 51.672 11.082 50.266 11.082\n"
                                              " c 49.523 11.082 48.922 11.402 48.461 12.043 c 48.008 12.676 47.785 13.492\n"
                                              " 47.785 14.492 c 47.785 20.828 l 44.715 20.828 l 44.715 11.652 l 44.715 \n"
                                              "11.02 44.703 10.5 44.684 10.102 c 44.668 9.695 44.652 9.328 44.629 9.008\n"
                                              " c 47.559 9.008 l 47.582 9.145 47.609 9.52 47.645 10.121 c 47.68 10.719 \n"
                                              "47.699 11.129 47.699 11.355 c 47.742 11.355 l 48.156 10.453 48.68 9.797 \n"
                                              "49.305 9.387 c 49.93 8.98 50.68 8.773 51.543 8.773 c 52.797 8.773 53.758\n"
                                              " 9.16 54.426 9.934 c 55.098 10.707 55.43 11.836 55.43 13.32 c 55.43 20.828\n"
                                              " l h\n"
                                              "52.375 20.828 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "61.992 11.082 m 61.992 20.828 l 58.93 20.828 l 58.93 11.082 l 57.203 11.082\n"
                                              " l 57.203 9.008 l 58.93 9.008 l 58.93 7.773 l 58.93 6.703 59.215 5.91 59.781\n"
                                              " 5.391 c 60.348 4.875 61.211 4.613 62.371 4.613 c 62.945 4.613 63.594 4.672\n"
                                              " 64.316 4.789 c 64.316 6.766 l 64.02 6.699 63.719 6.668 63.422 6.668 c 62.898\n"
                                              " 6.668 62.527 6.773 62.309 6.984 c 62.098 7.188 61.992 7.551 61.992 8.078\n"
                                              " c 61.992 9.008 l 64.32 9.008 l 64.32 11.082 l h\n"
                                              "61.992 11.082 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "65.836 6.875 m 65.836 4.613 l 68.906 4.613 l 68.906 6.875 l h\n"
                                              "65.836 20.828 m 65.836 9.008 l 68.906 9.008 l 68.906 20.832 l h\n"
                                              "65.836 20.828 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "79.715 20.828 m 79.688 20.719 79.648 20.445 79.605 20.008 c 79.57 19.562\n"
                                              " 79.551 19.195 79.551 18.902 c 79.508 18.902 l 78.844 20.332 77.586 21.043\n"
                                              " 75.727 21.043 c 74.352 21.043 73.285 20.508 72.535 19.438 c 71.785 18.359\n"
                                              " 71.41 16.855 71.41 14.926 c 71.41 12.965 71.805 11.453 72.59 10.391 c 73.383\n"
                                              " 9.32 74.504 8.785 75.957 8.785 c 76.793 8.785 77.516 8.961 78.121 9.309\n"
                                              " c 78.734 9.66 79.203 10.18 79.531 10.871 c 79.555 10.871 l 79.531 8.926\n"
                                              " l 79.531 4.609 l 82.602 4.609 l 82.602 18.246 l 82.602 18.973 82.629 19.836\n"
                                              " 82.688 20.824 c h\n"
                                              "79.574 14.852 m 79.574 13.578 79.359 12.598 78.93 11.914 c 78.508 11.223\n"
                                              " 77.879 10.875 77.051 10.875 c 76.227 10.875 75.617 11.211 75.215 11.879\n"
                                              " c 74.812 12.543 74.613 13.559 74.613 14.926 c 74.613 17.605 75.418 18.945\n"
                                              " 77.027 18.945 c 77.836 18.945 78.461 18.594 78.906 17.887 c 79.352 17.172\n"
                                              " 79.574 16.16 79.574 14.848 c h\n"
                                              "79.574 14.852 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "90.566 21.047 m 88.789 21.047 87.422 20.523 86.469 19.473 c 85.516 18.418\n"
                                              " 85.039 16.879 85.039 14.863 c 85.039 12.91 85.523 11.41 86.492 10.363 c\n"
                                              " 87.461 9.312 88.836 8.789 90.613 8.789 c 92.312 8.789 93.605 9.355 94.504\n"
                                              " 10.484 c 95.398 11.605 95.848 13.254 95.848 15.422 c 95.848 15.508 l 88.266\n"
                                              " 15.508 l 88.266 16.66 88.477 17.527 88.898 18.121 c 89.328 18.703 89.938\n"
                                              " 18.996 90.723 18.996 c 91.809 18.996 92.492 18.527 92.777 17.586 c 95.672\n"
                                              " 17.836 l 94.836 19.977 93.133 21.047 90.57 21.047 c h\n"
                                              "90.566 10.723 m 89.844 10.723 89.289 10.973 88.895 11.477 c 88.508 11.98\n"
                                              " 88.305 12.684 88.281 13.586 c 92.871 13.586 l 92.812 12.633 92.582 11.918\n"
                                              " 92.184 11.445 c 91.781 10.965 91.242 10.723 90.566 10.723 c h\n"
                                              "90.566 10.723 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "105.828 20.828 m 105.828 14.195 l 105.828 12.121 105.125 11.082 103.719\n"
                                              " 11.082 c 102.977 11.082 102.375 11.402 101.914 12.043 c 101.461 12.676 \n"
                                              "101.238 13.492 101.238 14.492 c 101.238 20.828 l 98.168 20.828 l 98.168 \n"
                                              "11.652 l 98.168 11.02 98.156 10.5 98.137 10.102 c 98.121 9.695 98.105 9.328\n"
                                              " 98.082 9.008 c 101.012 9.008 l 101.035 9.145 101.062 9.52 101.098 10.121\n"
                                              " c 101.133 10.719 101.152 11.129 101.152 11.355 c 101.195 11.355 l 101.609\n"
                                              " 10.453 102.133 9.797 102.758 9.387 c 103.383 8.98 104.133 8.773 104.996\n"
                                              " 8.773 c 106.25 8.773 107.211 9.16 107.879 9.934 c 108.551 10.707 108.883\n"
                                              " 11.836 108.883 13.32 c 108.883 20.828 l h\n"
                                              "105.828 20.828 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "114.867 21.027 m 113.965 21.027 113.27 20.785 112.781 20.297 c 112.293 \n"
                                              "19.801 112.051 19.055 112.051 18.059 c 112.051 11.086 l 110.555 11.086 l\n"
                                              " 110.555 9.012 l 112.203 9.012 l 113.164 6.234 l 115.086 6.234 l 115.086\n"
                                              " 9.012 l 117.324 9.012 l 117.324 11.086 l 115.086 11.086 l 115.086 17.227\n"
                                              " l 115.086 17.801 115.195 18.227 115.414 18.504 c 115.633 18.773 115.973\n"
                                              " 18.906 116.43 18.906 c 116.672 18.906 117.012 18.855 117.457 18.754 c 117.457\n"
                                              " 20.656 l 116.699 20.902 115.836 21.027 114.867 21.027 c h\n"
                                              "114.867 21.027 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "119.293 6.875 m 119.293 4.613 l 122.363 4.613 l 122.363 6.875 l h\n"
                                              "119.293 20.828 m 119.293 9.008 l 122.363 9.008 l 122.363 20.832 l h\n"
                                              "119.293 20.828 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "128.242 21.047 m 127.098 21.047 126.207 20.738 125.566 20.117 c 124.926\n"
                                              " 19.492 124.605 18.613 124.605 17.484 c 124.605 16.262 125.004 15.328 125.797\n"
                                              " 14.688 c 126.598 14.047 127.758 13.719 129.273 13.703 c 131.82 13.66 l \n"
                                              "131.82 13.059 l 131.82 12.285 131.688 11.715 131.418 11.344 c 131.148 10.965\n"
                                              " 130.707 10.777 130.098 10.777 c 129.531 10.777 129.109 10.91 128.84 11.172\n"
                                              " c 128.578 11.426 128.414 11.852 128.348 12.449 c 125.145 12.297 l 125.34\n"
                                              " 11.145 125.867 10.277 126.719 9.684 c 127.578 9.086 128.746 8.789 130.227\n"
                                              " 8.789 c 131.719 8.789 132.871 9.156 133.68 9.895 c 134.488 10.629 134.891\n"
                                              " 11.676 134.891 13.031 c 134.891 17.336 l 134.891 18 134.965 18.457 135.109\n"
                                              " 18.711 c 135.262 18.957 135.512 19.082 135.863 19.082 c 136.098 19.082 \n"
                                              "136.32 19.059 136.539 19.016 c 136.539 20.676 l 136.355 20.719 136.191 20.758\n"
                                              " 136.047 20.797 c 135.902 20.832 135.754 20.863 135.609 20.883 c 135.465\n"
                                              " 20.906 135.309 20.922 135.141 20.938 c 134.98 20.953 134.789 20.961 134.574\n"
                                              " 20.961 c 133.801 20.961 133.23 20.773 132.859 20.395 c 132.496 20.016 132.277\n"
                                              " 19.457 132.203 18.723 c 132.137 18.723 l 131.277 20.273 129.98 21.051 128.246\n"
                                              " 21.051 c h\n"
                                              "131.816 15.355 m 130.242 15.379 l 129.527 15.406 129.023 15.488 128.723\n"
                                              " 15.621 c 128.426 15.746 128.195 15.938 128.035 16.199 c 127.883 16.461 \n"
                                              "127.805 16.812 127.805 17.25 c 127.805 17.812 127.934 18.23 128.188 18.508\n"
                                              " c 128.449 18.777 128.797 18.91 129.227 18.91 c 129.707 18.91 130.145 18.777\n"
                                              " 130.539 18.516 c 130.941 18.254 131.254 17.895 131.48 17.434 c 131.707 \n"
                                              "16.969 131.82 16.477 131.82 15.957 c h\n"
                                              "131.816 15.355 m B Q\n"
                                              "0.74902 0 0 rg 1 1 1 RG q 1 0 0 1 0 0 cm\n"
                                              "137.953 4.613 3.07 16.215 re B Q\n"
                                              "Q q\n"
                                              "0.74902 0.0117647 0.0117647 rg /a1 gs\n"
                                              "1 1 1 RG 0.797243 w\n"
                                              "1 J\n"
                                              "1 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                              "24.715 1.77 26.086 3.398 26.086 c 152.109 26.086 l 153.738 26.086 155.109\n"
                                              " 24.715 155.109 23.086 c 155.109 3.398 l 155.109 1.77 153.738 0.398 152.109\n"
                                              " 0.398 c h\n"
                                              "3.867 3.844 m 151.664 3.844 l 151.664 22.617 l 3.867 22.617 l h\n"
                                              "3.867 3.844 m B Q\n"
                                              "Q\n";

static std::unique_ptr<Dict> getConfidentialStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
