//========================================================================
//
// annot_stamp_as_is.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2026 g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_AS_IS_H
#define ANNOT_STAMP_AS_IS_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"
#include "annot_stamp.h"

static const double ANNOT_STAMP_AS_IS_WIDTH = 79.758179;
static const double ANNOT_STAMP_AS_IS_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_AS_IS = "1 0 0 -1 0 26.484744 cm\n"
                                       "q\n"
                                       "1 1 1 rg /a0 gs\n"
                                       "3.406 2.129 m 76.367 2.129 l 77.066 2.129 77.637 2.828 77.637 3.398 c 77.637\n"
                                       " 23.09 l 77.637 23.789 77.07 24.359 76.367 24.359 c 3.406 24.359 l 2.707\n"
                                       " 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703 2.129 \n"
                                       "3.406 2.129 c h\n"
                                       "3.406 2.129 m f\n"
                                       "0 0.298039 0.431373 rg /a1 gs\n"
                                       "1 1 1 RG 0.265748 w\n"
                                       "0 J\n"
                                       "0 j\n"
                                       "[] 0.0 d\n"
                                       "4 M q 1 0 0 1 0 0 cm\n"
                                       "25.703 20.828 m 24.336 16.895 l 18.469 16.895 l 17.102 20.828 l 13.879 \n"
                                       "20.828 l 19.496 5.434 l 23.297 5.434 l 28.891 20.828 l 25.699 20.828 l 22.098\n"
                                       " 10.043 m 22.012 9.789 21.922 9.531 21.836 9.277 c 21.754 9.016 21.684 8.777\n"
                                       " 21.617 8.566 c 21.559 8.348 21.508 8.168 21.465 8.031 c 21.43 7.895 21.406\n"
                                       " 7.816 21.398 7.801 c 21.391 7.824 21.371 7.902 21.332 8.043 c 21.297 8.18\n"
                                       " 21.246 8.355 21.18 8.566 c 21.121 8.777 21.047 9.016 20.961 9.277 c 20.879\n"
                                       " 9.531 20.797 9.789 20.711 10.043 c 19.191 14.469 l 23.617 14.469 l 22.098\n"
                                       " 10.043 l 41.023 17.375 m 41.023 17.941 40.902 18.453 40.664 18.906 c 40.43\n"
                                       " 19.359 40.09 19.742 39.637 20.066 c 39.184 20.379 38.633 20.625 37.977 \n"
                                       "20.797 c 37.32 20.965 36.574 21.047 35.738 21.047 c 34.988 21.047 34.309\n"
                                       " 20.992 33.707 20.883 c 33.102 20.773 32.57 20.594 32.113 20.348 c 31.66\n"
                                       " 20.094 31.281 19.766 30.977 19.363 c 30.672 18.961 30.441 18.469 30.289\n"
                                       " 17.879 c 32.988 17.477 l 33.074 17.805 33.195 18.07 33.348 18.273 c 33.5\n"
                                       " 18.477 33.691 18.633 33.914 18.742 c 34.141 18.852 34.402 18.926 34.699\n"
                                       " 18.961 c 35.004 18.996 35.352 19.016 35.738 19.016 c 36.09 19.016 36.41\n"
                                       " 18.996 36.711 18.961 c 37.016 18.918 37.277 18.848 37.496 18.754 c 37.723\n"
                                       " 18.652 37.898 18.512 38.02 18.34 c 38.145 18.156 38.207 17.934 38.207 17.664\n"
                                       " c 38.207 17.359 38.117 17.117 37.934 16.941 c 37.758 16.758 37.516 16.613\n"
                                       " 37.203 16.504 c 36.898 16.387 36.531 16.289 36.109 16.207 c 35.695 16.121\n"
                                       " 35.25 16.02 34.777 15.91 c 34.281 15.801 33.793 15.668 33.312 15.516 c \n"
                                       "32.832 15.363 32.402 15.156 32.023 14.895 c 31.645 14.633 31.34 14.301 31.105\n"
                                       " 13.898 c 30.871 13.492 30.754 12.977 30.754 12.359 c 30.754 11.797 30.863\n"
                                       " 11.301 31.082 10.863 c 31.301 10.418 31.621 10.043 32.043 9.738 c 32.465\n"
                                       " 9.426 32.984 9.188 33.605 9.027 c 34.23 8.859 34.949 8.777 35.758 8.777\n"
                                       " c 36.398 8.777 36.996 8.84 37.551 8.965 c 38.105 9.082 38.602 9.27 39.035\n"
                                       " 9.531 c 39.473 9.785 39.836 10.113 40.129 10.516 c 40.426 10.918 40.637\n"
                                       " 11.402 40.75 11.969 c 38.027 12.254 l 37.977 11.969 37.887 11.738 37.754\n"
                                       " 11.555 c 37.621 11.367 37.457 11.215 37.262 11.105 c 37.074 10.996 36.852\n"
                                       " 10.922 36.594 10.887 c 36.34 10.844 36.059 10.82 35.754 10.82 c 35.027 \n"
                                       "10.82 34.48 10.914 34.113 11.105 c 33.75 11.289 33.566 11.598 33.566 12.035\n"
                                       " c 33.566 12.305 33.641 12.52 33.785 12.68 c 33.938 12.84 34.148 12.977 \n"
                                       "34.418 13.082 c 34.695 13.184 35.02 13.273 35.391 13.355 c 35.77 13.43 36.18\n"
                                       " 13.52 36.625 13.629 c 37.172 13.746 37.707 13.883 38.23 14.043 c 38.762\n"
                                       " 14.195 39.23 14.41 39.641 14.688 c 40.055 14.957 40.387 15.309 40.637 15.738\n"
                                       " c 40.891 16.168 41.02 16.715 41.02 17.379 c 49.656 20.828 m 49.656 5.434\n"
                                       " l 52.879 5.434 l 52.879 20.828 l 49.656 20.828 l 65.891 17.375 m 65.891\n"
                                       " 17.941 65.77 18.453 65.531 18.906 c 65.297 19.359 64.957 19.742 64.504 \n"
                                       "20.066 c 64.051 20.379 63.5 20.625 62.844 20.797 c 62.188 20.965 61.441 \n"
                                       "21.047 60.605 21.047 c 59.855 21.047 59.176 20.992 58.574 20.883 c 57.969\n"
                                       " 20.773 57.438 20.594 56.98 20.348 c 56.527 20.094 56.148 19.766 55.844 \n"
                                       "19.363 c 55.539 18.961 55.309 18.469 55.156 17.879 c 57.855 17.477 l 57.941\n"
                                       " 17.805 58.062 18.07 58.215 18.273 c 58.367 18.477 58.559 18.633 58.781 \n"
                                       "18.742 c 59.008 18.852 59.27 18.926 59.566 18.961 c 59.871 18.996 60.219\n"
                                       " 19.016 60.605 19.016 c 60.957 19.016 61.277 18.996 61.578 18.961 c 61.883\n"
                                       " 18.918 62.145 18.848 62.363 18.754 c 62.59 18.652 62.766 18.512 62.887 \n"
                                       "18.34 c 63.012 18.156 63.074 17.934 63.074 17.664 c 63.074 17.359 62.984\n"
                                       " 17.117 62.801 16.941 c 62.625 16.758 62.383 16.613 62.07 16.504 c 61.766\n"
                                       " 16.387 61.398 16.289 60.977 16.207 c 60.562 16.121 60.117 16.02 59.645 \n"
                                       "15.91 c 59.148 15.801 58.66 15.668 58.18 15.516 c 57.699 15.363 57.27 15.156\n"
                                       " 56.891 14.895 c 56.512 14.633 56.207 14.301 55.973 13.898 c 55.738 13.492\n"
                                       " 55.621 12.977 55.621 12.359 c 55.621 11.797 55.73 11.301 55.949 10.863 \n"
                                       "c 56.168 10.418 56.488 10.043 56.91 9.738 c 57.332 9.426 57.852 9.188 58.473\n"
                                       " 9.027 c 59.098 8.859 59.816 8.777 60.625 8.777 c 61.266 8.777 61.863 8.84\n"
                                       " 62.418 8.965 c 62.973 9.082 63.469 9.27 63.902 9.531 c 64.34 9.785 64.703\n"
                                       " 10.113 64.996 10.516 c 65.293 10.918 65.504 11.402 65.617 11.969 c 62.895\n"
                                       " 12.254 l 62.844 11.969 62.754 11.738 62.621 11.555 c 62.488 11.367 62.324\n"
                                       " 11.215 62.129 11.105 c 61.941 10.996 61.719 10.922 61.461 10.887 c 61.207\n"
                                       " 10.844 60.926 10.82 60.621 10.82 c 59.895 10.82 59.348 10.914 58.98 11.105\n"
                                       " c 58.617 11.289 58.434 11.598 58.434 12.035 c 58.434 12.305 58.508 12.52\n"
                                       " 58.652 12.68 c 58.805 12.84 59.016 12.977 59.285 13.082 c 59.562 13.184\n"
                                       " 59.887 13.273 60.258 13.355 c 60.637 13.43 61.047 13.52 61.492 13.629 c\n"
                                       " 62.039 13.746 62.574 13.883 63.098 14.043 c 63.629 14.195 64.098 14.41 \n"
                                       "64.508 14.688 c 64.922 14.957 65.254 15.309 65.504 15.738 c 65.758 16.168\n"
                                       " 65.887 16.715 65.887 17.379 c B Q\n"
                                       "Q q\n"
                                       "0 0.298039 0.431373 rg /a1 gs\n"
                                       "1 1 1 RG 0.797243 w\n"
                                       "1 J\n"
                                       "1 j\n"
                                       "[] 0.0 d\n"
                                       "4 M q 1 0 0 1 0 0 cm\n"
                                       "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                       "24.715 1.77 26.086 3.398 26.086 c 76.359 26.086 l 77.988 26.086 79.359 24.715\n"
                                       " 79.359 23.086 c 79.359 3.398 l 79.359 1.77 77.988 0.398 76.359 0.398 c \n"
                                       "h\n"
                                       "3.867 3.844 m 75.914 3.844 l 75.914 22.617 l 3.867 22.617 l h\n"
                                       "3.867 3.844 m B Q\n"
                                       "Q\n";

static std::unique_ptr<Dict> getAsIsStampExtGStateDict(PDFDoc *doc)
{
    return getStampExtGStateDict(doc, 0.588235, 0.588235);
}

#endif
